/*
 * Decompiled with CFR 0.152.
 */
package Hack.VMEmulator;

import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.ValueComputerPart;
import Hack.VMEmulator.CalculatorGUI;

public class Calculator
extends ValueComputerPart {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int NEGATE = 2;
    public static final int AND = 3;
    public static final int OR = 4;
    public static final int NOT = 5;
    public static final int EQUAL = 6;
    public static final int GREATER_THAN = 7;
    public static final int LESS_THAN = 8;
    public static final char ADD_SYMBOL = '+';
    public static final char SUBTRACT_SYMBOL = '-';
    public static final char NEGATE_SYMBOL = '-';
    public static final char AND_SYMBOL = '&';
    public static final char OR_SYMBOL = '|';
    public static final char NOT_SYMBOL = '!';
    public static final char EQUAL_SYMBOL = '=';
    public static final char GREATER_THAN_SYMBOL = '>';
    public static final char LESS_THAN_SYMBOL = '<';
    private CalculatorGUI gui;
    private char[] operators;
    private short input0;
    private short input1;
    private short output;

    public Calculator(CalculatorGUI calculatorGUI) {
        super(calculatorGUI != null);
        this.gui = calculatorGUI;
        this.operators = new char[9];
        this.operators[0] = 43;
        this.operators[1] = 45;
        this.operators[2] = 45;
        this.operators[3] = 38;
        this.operators[4] = 124;
        this.operators[5] = 33;
        this.operators[6] = 61;
        this.operators[7] = 62;
        this.operators[8] = 60;
    }

    public void compute(int n) {
        short s = 0;
        switch (n) {
            case 0: {
                s = (short)(this.input0 + this.input1);
                break;
            }
            case 1: {
                s = (short)(this.input0 - this.input1);
                break;
            }
            case 2: {
                s = -this.input1;
                break;
            }
            case 3: {
                s = (short)(this.input0 & this.input1);
                break;
            }
            case 4: {
                s = (short)(this.input0 | this.input1);
                break;
            }
            case 5: {
                s = ~this.input1;
                break;
            }
            case 6: {
                s = (short)(this.input0 == this.input1 ? -1 : 0);
                break;
            }
            case 7: {
                s = (short)(this.input0 > this.input1 ? -1 : 0);
                break;
            }
            case 8: {
                s = (short)(this.input0 < this.input1 ? -1 : 0);
            }
        }
        this.setValueAt(2, s, true);
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public short getValueAt(int n) {
        short s = 0;
        switch (n) {
            case 0: {
                s = this.input0;
                break;
            }
            case 1: {
                s = this.input1;
                break;
            }
            case 2: {
                s = this.output;
            }
        }
        return s;
    }

    public void doSetValueAt(int n, short s) {
        switch (n) {
            case 0: {
                this.input0 = s;
                break;
            }
            case 1: {
                this.input1 = s;
                break;
            }
            case 2: {
                this.output = s;
            }
        }
    }

    public void reset() {
        super.reset();
        this.input0 = this.nullValue;
        this.input1 = this.nullValue;
        this.output = this.nullValue;
    }

    public void refreshGUI() {
        this.quietUpdateGUI(0, this.input0);
        this.quietUpdateGUI(1, this.input1);
        this.quietUpdateGUI(2, this.output);
    }

    public void showCalculator(int n, int n2) {
        if (this.animate) {
            if (n2 == 2) {
                this.gui.showLeftInput();
            } else {
                this.gui.hideLeftInput();
            }
            this.gui.reset();
            this.gui.setOperator(this.operators[n]);
            this.gui.showCalculator();
        }
    }

    public void hideCalculator() {
        if (this.animate) {
            this.gui.hideCalculator();
        }
    }
}

