/*
 * Decompiled with CFR 0.152.
 */
package Hack.VMEmulator;

import Hack.CPUEmulator.RAM;
import Hack.ComputerParts.AbsolutePointedMemorySegment;
import Hack.ComputerParts.Bus;
import Hack.ComputerParts.MemorySegment;
import Hack.ComputerParts.PointedMemorySegment;
import Hack.ComputerParts.TrimmedAbsoluteMemorySegment;
import Hack.ComputerParts.ValueComputerPart;
import Hack.Controller.ProgramException;
import Hack.VMEmulator.BuiltInFunctionsRunner;
import Hack.VMEmulator.Calculator;
import Hack.VMEmulator.CallStack;
import Hack.VMEmulator.VMEmulatorInstruction;
import Hack.VMEmulator.VMProgram;
import java.io.File;
import java.util.Vector;

public class CPU {
    private static final int MAIN_STACK = 1;
    private static final int METHOD_STACK = 2;
    private VMProgram program;
    private RAM ram;
    private CallStack callStack;
    private Calculator calculator;
    private Bus bus;
    private AbsolutePointedMemorySegment stackSegment;
    private TrimmedAbsoluteMemorySegment workingStackSegment;
    private MemorySegment staticSegment;
    private MemorySegment localSegment;
    private MemorySegment argSegment;
    private MemorySegment thisSegment;
    private MemorySegment thatSegment;
    private MemorySegment tempSegment;
    private MemorySegment[] segments;
    private Vector stackFrames;
    private VMEmulatorInstruction currentInstruction;
    private BuiltInFunctionsRunner builtInFunctionsRunner;

    public CPU(VMProgram vMProgram, RAM rAM, CallStack callStack, Calculator calculator, Bus bus, AbsolutePointedMemorySegment absolutePointedMemorySegment, TrimmedAbsoluteMemorySegment trimmedAbsoluteMemorySegment, MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5, MemorySegment memorySegment6, File file) {
        this.program = vMProgram;
        this.ram = rAM;
        this.callStack = callStack;
        this.calculator = calculator;
        this.bus = bus;
        this.stackSegment = absolutePointedMemorySegment;
        this.workingStackSegment = trimmedAbsoluteMemorySegment;
        this.staticSegment = memorySegment;
        this.localSegment = memorySegment2;
        this.argSegment = memorySegment3;
        this.thisSegment = memorySegment4;
        this.thatSegment = memorySegment5;
        this.tempSegment = memorySegment6;
        this.segments = new MemorySegment[5];
        this.segments[0] = memorySegment2;
        this.segments[1] = memorySegment3;
        this.segments[2] = memorySegment4;
        this.segments[3] = memorySegment5;
        this.segments[4] = memorySegment6;
        this.stackFrames = new Vector();
        if (vMProgram.getGUI() != null) {
            this.builtInFunctionsRunner = new BuiltInFunctionsRunner(this, file);
        }
    }

    public void boot() {
        this.stackSegment.setStartAddress(256);
        this.workingStackSegment.setStartAddress(256);
        this.localSegment.setEnabledRange(256, 2047, true);
        this.argSegment.setEnabledRange(256, 2047, true);
        this.thisSegment.setEnabledRange(2048, 16383, true);
        this.thatSegment.setEnabledRange(2048, 24576, true);
        this.staticSegment.setStartAddress(16);
        this.staticSegment.setEnabledRange(16, 254, true);
        this.setSP((short)256);
        this.stackFrames.clear();
        if (this.builtInFunctionsRunner != null) {
            this.builtInFunctionsRunner.killAllRunningBuiltInFunctions();
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public RAM getRAM() {
        return this.ram;
    }

    public VMProgram getProgram() {
        return this.program;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }

    public MemorySegment[] getMemorySegments() {
        return this.segments;
    }

    public PointedMemorySegment getStack() {
        return this.stackSegment;
    }

    public PointedMemorySegment getWorkingStack() {
        return this.workingStackSegment;
    }

    public VMEmulatorInstruction getCurrentInstruction() {
        return this.currentInstruction;
    }

    public void executeInstruction() throws ProgramException {
        this.currentInstruction = this.program.getNextInstruction();
        if (this.currentInstruction == null) {
            throw new ProgramException("No more instructions to execute");
        }
        switch (this.currentInstruction.getOpCode()) {
            case 1: {
                this.add();
                break;
            }
            case 2: {
                this.substract();
                break;
            }
            case 3: {
                this.negate();
                break;
            }
            case 4: {
                this.equal();
                break;
            }
            case 5: {
                this.greaterThan();
                break;
            }
            case 6: {
                this.lessThan();
                break;
            }
            case 7: {
                this.and();
                break;
            }
            case 8: {
                this.or();
                break;
            }
            case 9: {
                this.not();
                break;
            }
            case 10: {
                this.push(this.currentInstruction.getArg0(), this.currentInstruction.getArg1());
                break;
            }
            case 11: {
                this.pop(this.currentInstruction.getArg0(), this.currentInstruction.getArg1());
                break;
            }
            case 13: {
                this.goTo(this.currentInstruction.getArg0());
                break;
            }
            case 14: {
                this.ifGoTo(this.currentInstruction.getArg0());
                break;
            }
            case 15: {
                if (this.program.getCurrentPC() == this.program.getPreviousPC() + 1) {
                    throw new ProgramException("Missing return in " + this.callStack.getTopFunction());
                }
                this.function(this.currentInstruction.getArg0());
                break;
            }
            case 16: {
                this.returnFromFunction();
                break;
            }
            case 17: {
                this.callFunction(this.currentInstruction.getArg0(), this.currentInstruction.getArg1(), this.currentInstruction.getStringArg(), false);
            }
        }
    }

    public void add() throws ProgramException {
        this.calculate(2, 0);
    }

    public void substract() throws ProgramException {
        this.calculate(2, 1);
    }

    public void negate() throws ProgramException {
        this.calculate(1, 2);
    }

    public void equal() throws ProgramException {
        this.calculate(2, 6);
    }

    public void greaterThan() throws ProgramException {
        this.calculate(2, 7);
    }

    public void lessThan() throws ProgramException {
        this.calculate(2, 8);
    }

    public void and() throws ProgramException {
        this.calculate(2, 3);
    }

    public void or() throws ProgramException {
        this.calculate(2, 4);
    }

    public void not() throws ProgramException {
        this.calculate(1, 5);
    }

    public void push(short s, short s2) throws ProgramException {
        if (s == 101) {
            this.pushValue(2, s2);
        } else if (s == 102) {
            switch (s2) {
                case 0: {
                    this.pushFromRAM(2, 3);
                    break;
                }
                case 1: {
                    this.pushFromRAM(2, 4);
                }
            }
        } else {
            this.pushFromSegment(2, s, s2);
        }
    }

    public void pop(short s, short s2) throws ProgramException {
        if (s == 102) {
            switch (s2) {
                case 0: {
                    this.popToThisPointer(2);
                    break;
                }
                case 1: {
                    this.popToThatPointer(2);
                }
            }
        } else {
            this.popToSegment(2, s, s2);
        }
    }

    public void goTo(short s) {
        this.program.setPC(s);
    }

    public void ifGoTo(short s) throws ProgramException {
        if (this.popAndReturn() != 0) {
            this.program.setPC(s);
        }
    }

    public void function(short n) throws ProgramException {
        short s = (short)(this.getSP() + n);
        this.checkSP(s);
        this.workingStackSegment.setStartAddress((int)s);
        this.localSegment.setEnabledRange((int)this.getSP(), s - 1, true);
        for (int i = 0; i < n; ++i) {
            this.pushValue(1, (short)0);
        }
        String string = this.currentInstruction.getStringArg();
        this.callStack.pushFunction(string);
        this.setStaticRange(string);
    }

    public void infiniteLoopFromBuiltIn(String string) {
        this.program.setPCToInfiniteLoopForBuiltIns(string);
    }

    public void returnFromBuiltInFunction(short s) throws ProgramException {
        this.pushValue(2, s);
        this.returnFromFunction();
    }

    public void returnFromFunction() throws ProgramException {
        short s;
        if (this.stackSegment.getValueAt(1) == 0) {
            throw new ProgramException("Nowhere to return to in " + this.getCallStack().getTopFunction() + "." + this.getCurrentInstruction().getIndexInFunction());
        }
        this.workingStackSegment.setStartAddress((int)this.getSP());
        this.bus.send((ValueComputerPart)this.ram, 1, (ValueComputerPart)this.ram, 13);
        this.bus.send((ValueComputerPart)this.stackSegment, this.stackSegment.getValueAt(1) - 5, (ValueComputerPart)this.ram, 14);
        this.bus.send((ValueComputerPart)this.stackSegment, this.getSP() - 1, (ValueComputerPart)this.stackSegment, (int)this.ram.getValueAt(2));
        this.setSP((short)(this.ram.getValueAt(2) + 1));
        this.bus.send((ValueComputerPart)this.stackSegment, this.ram.getValueAt(13) - 1, (ValueComputerPart)this.ram, 4);
        this.bus.send((ValueComputerPart)this.stackSegment, this.ram.getValueAt(13) - 2, (ValueComputerPart)this.ram, 3);
        this.bus.send((ValueComputerPart)this.stackSegment, this.ram.getValueAt(13) - 3, (ValueComputerPart)this.ram, 2);
        this.bus.send((ValueComputerPart)this.stackSegment, this.ram.getValueAt(13) - 4, (ValueComputerPart)this.ram, 1);
        this.callStack.popFunction();
        if (this.stackFrames.size() > 0) {
            int s2 = (Integer)this.stackFrames.lastElement();
            this.stackFrames.removeElementAt(this.stackFrames.size() - 1);
            this.workingStackSegment.setStartAddress(s2);
            this.localSegment.setEnabledRange(Math.max(this.localSegment.getStartAddress(), 256), s2 - 1, true);
            this.argSegment.setEnabledRange(this.argSegment.getStartAddress(), this.localSegment.getStartAddress() - 6, true);
            this.thisSegment.setEnabledRange(Math.max(this.thisSegment.getStartAddress(), 2048), 16383, true);
            this.thatSegment.setEnabledRange(Math.max(this.thatSegment.getStartAddress(), 2048), 24576, true);
        }
        if ((s = this.ram.getValueAt(14)) == -1) {
            this.staticSegment.setEnabledRange(0, -1, true);
            this.builtInFunctionsRunner.returnToBuiltInFunction(this.popValue(2));
        } else if (s >= 0 && s < this.program.getSize()) {
            if (this.stackFrames.size() > 0) {
                this.setStaticRange(this.callStack.getTopFunction());
            } else {
                this.staticSegment.setStartAddress(16);
                this.staticSegment.setEnabledRange(16, 254, true);
            }
            this.program.setPC((short)(s - 1));
            this.program.setPC(s);
        } else {
            this.error("Illegal return address");
        }
    }

    public void callFunctionFromBuiltIn(String string, short[] sArray) throws ProgramException {
        for (int i = 0; i < sArray.length; ++i) {
            this.pushValue(2, sArray[i]);
        }
        this.callFunction(this.program.getAddress(string), (short)sArray.length, string, true);
    }

    public void callFunction(short s, short n, String string, boolean bl) throws ProgramException {
        this.stackFrames.addElement(new Integer(this.workingStackSegment.getStartAddress()));
        this.workingStackSegment.setStartAddress(this.getSP() + 5);
        if (bl) {
            this.pushValue(1, (short)-1);
        } else {
            this.pushValue(1, this.program.getPC());
        }
        this.pushFromRAM(1, 1);
        this.pushFromRAM(1, 2);
        this.pushFromRAM(1, 3);
        this.pushFromRAM(1, 4);
        this.ram.setValueAt(2, (short)(this.getSP() - n - 5), false);
        this.ram.setValueAt(1, this.getSP(), false);
        this.argSegment.setEnabledRange(this.argSegment.getStartAddress(), this.argSegment.getStartAddress() + n - 1, true);
        if (s == -1) {
            this.localSegment.setEnabledRange(this.localSegment.getStartAddress(), this.localSegment.getStartAddress() - 1, true);
            this.callStack.pushFunction(string + " (built-in)");
            this.staticSegment.setEnabledRange(0, -1, true);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = this.argSegment.getValueAt(i);
            }
            this.builtInFunctionsRunner.callBuiltInFunction(string, sArray);
        } else if (s >= 0 || s < this.program.getSize()) {
            this.program.setPC(s);
            this.program.setPC(s);
        } else {
            this.error("Illegal call address");
        }
    }

    protected void setStaticRange(String string) throws ProgramException {
        int n = string.indexOf(".");
        if (n == -1) {
            throw new ProgramException("Illegal function name: " + string);
        }
        String string2 = string.substring(0, n);
        int[] nArray = this.program.getStaticRange(string2);
        if (nArray == null) {
            throw new ProgramException("Function name doesn't match class name: " + string);
        }
        this.staticSegment.setStartAddress(nArray[0]);
        this.staticSegment.setEnabledRange(nArray[0], nArray[1], true);
    }

    private void calculate(int n, int n2) throws ProgramException {
        this.calculator.showCalculator(n2, n);
        this.popToCalculator(2, 1);
        if (n > 1) {
            this.popToCalculator(2, 0);
        }
        this.calculator.compute(n2);
        this.pushFromCalculator(2, 2);
        this.calculator.hideCalculator();
    }

    private void pushValue(int n, short s) throws ProgramException {
        short s2 = this.getSP();
        if (n == 1) {
            this.stackSegment.setValueAt((int)s2, s, false);
        } else {
            this.workingStackSegment.setValueAt((int)s2, s, false);
        }
        this.checkSP((short)(s2 + 1));
        this.setSP((short)(s2 + 1));
    }

    private void pushFromRAM(int n, int n2) throws ProgramException {
        short s = this.getSP();
        this.bus.send((ValueComputerPart)this.ram, n2, (ValueComputerPart)(n == 1 ? this.stackSegment : this.workingStackSegment), (int)s);
        this.checkSP((short)(s + 1));
        this.setSP((short)(s + 1));
    }

    private void pushFromCalculator(int n, int n2) throws ProgramException {
        short s = this.getSP();
        this.bus.send((ValueComputerPart)this.calculator, n2, (ValueComputerPart)(n == 1 ? this.stackSegment : this.workingStackSegment), (int)s);
        this.checkSP((short)(s + 1));
        this.setSP((short)(s + 1));
    }

    private void pushFromSegment(int n, short s, int n2) throws ProgramException {
        short s2 = this.getSP();
        MemorySegment memorySegment = s == 100 ? this.staticSegment : this.segments[s];
        this.checkSegmentIndex(memorySegment, s, n2);
        this.bus.send((ValueComputerPart)memorySegment, n2, (ValueComputerPart)(n == 1 ? this.stackSegment : this.workingStackSegment), (int)s2);
        this.checkSP((short)(s2 + 1));
        this.setSP((short)(s2 + 1));
    }

    private void popToSegment(int n, short s, int n2) throws ProgramException {
        short s2 = (short)(this.getSP() - 1);
        MemorySegment memorySegment = s == 100 ? this.staticSegment : this.segments[s];
        this.checkSegmentIndex(memorySegment, s, n2);
        this.bus.send((ValueComputerPart)(n == 1 ? this.stackSegment : this.workingStackSegment), (int)s2, (ValueComputerPart)memorySegment, n2);
        this.checkSP(s2);
        this.setSP(s2);
    }

    private short popValue(int n) throws ProgramException {
        short s = (short)(this.getSP() - 1);
        short s2 = n == 1 ? this.stackSegment.getValueAt((int)s) : this.workingStackSegment.getValueAt((int)s);
        this.checkSP(s);
        this.setSP(s);
        return s2;
    }

    private void popToRAM(int n, int n2) throws ProgramException {
        short s = (short)(this.getSP() - 1);
        this.bus.send((ValueComputerPart)(n == 1 ? this.stackSegment : this.workingStackSegment), (int)s, (ValueComputerPart)this.ram, n2);
        this.checkSP(s);
        this.setSP(s);
    }

    private void popToThisPointer(int n) throws ProgramException {
        short s = this.ram.getValueAt(this.getSP() - 1);
        if ((s < 2048 || s > 16383) && s > 0) {
            this.error("'This' segment must be in the Heap range");
        }
        this.popToRAM(n, 3);
        this.thisSegment.setEnabledRange((int)s, 16383, true);
    }

    private void popToThatPointer(int n) throws ProgramException {
        short s = this.ram.getValueAt(this.getSP() - 1);
        if (!(s >= 2048 && s <= 16383 || s >= 16384 && s <= 24576 || s == 0)) {
            this.error("'That' segment must be in the Heap or Screen range");
        }
        this.popToRAM(n, 4);
        this.thatSegment.setEnabledRange((int)s, 24576, true);
    }

    private void popToCalculator(int n, int n2) throws ProgramException {
        short s = (short)(this.getSP() - 1);
        this.bus.send((ValueComputerPart)(n == 1 ? this.stackSegment : this.workingStackSegment), (int)s, (ValueComputerPart)this.calculator, n2);
        this.checkSP(s);
        this.setSP(s);
    }

    private short popAndReturn() throws ProgramException {
        short s = (short)(this.getSP() - 1);
        this.checkSP(s);
        this.setSP(s);
        return this.stackSegment.getValueAt((int)s);
    }

    public MemorySegment getStaticSegment() {
        return this.staticSegment;
    }

    public short getSegmentAt(short s, short s2) {
        return this.segments[s].getValueAt((int)s2);
    }

    public void setSegmentAt(short s, short s2, short s3) {
        this.segments[s].setValueAt((int)s2, s3, false);
    }

    public short getSP() {
        return this.ram.getValueAt(0);
    }

    public void setSP(short s) {
        this.ram.setValueAt(0, s, true);
    }

    private void checkSP(short s) throws ProgramException {
        if (s < 256 || s > 2047) {
            this.error("Stack overflow");
        }
    }

    private void checkSegmentIndex(MemorySegment memorySegment, int n, int n2) throws ProgramException {
        short s = (short)(n2 + memorySegment.getStartAddress());
        if (n == 2) {
            if (s < 2048 || s > 16383) {
                this.error("Out of segment space");
            }
        } else {
            int[] nArray = memorySegment.getEnabledRange();
            if (s < nArray[0] || s > nArray[1]) {
                this.error("Out of segment space");
            }
        }
    }

    private void error(String string) throws ProgramException {
        throw new ProgramException(string + " in " + this.callStack.getTopFunction() + "." + this.currentInstruction.getIndexInFunction());
    }
}

