/*
 * Decompiled with CFR 0.152.
 */
package Hack.HardwareSimulator;

import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.ComputerPartEventListener;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.InteractiveValueComputerPart;
import Hack.Events.ErrorEventListener;
import Hack.Gates.GateClass;
import Hack.Gates.Node;
import Hack.Gates.PinInfo;
import Hack.HardwareSimulator.NodePinsAdapter;
import Hack.HardwareSimulator.PinsGUI;

public class Pins
extends InteractiveValueComputerPart {
    private PinsGUI gui;
    private byte type;
    private Node[] nodes;
    private PinInfo[] pins;

    public Pins(byte by, PinsGUI pinsGUI) {
        super(pinsGUI != null);
        this.gui = pinsGUI;
        this.type = by;
        this.pins = new PinInfo[0];
        this.nodes = new Node[0];
        if (this.hasGUI) {
            pinsGUI.addListener((ComputerPartEventListener)this);
            pinsGUI.addErrorListener((ErrorEventListener)this);
            pinsGUI.setContents(this.pins);
        }
    }

    public void setNodes(Node[] nodeArray, GateClass gateClass) {
        this.nodes = nodeArray;
        this.pins = new PinInfo[nodeArray.length];
        for (int i = 0; i < this.pins.length; ++i) {
            this.pins[i] = gateClass.getPinInfo(this.type, i);
            this.pins[i].value = nodeArray[i].get();
            nodeArray[i].addListener(new NodePinsAdapter(this, i));
        }
        if (this.hasGUI) {
            this.gui.setContents(this.pins);
        }
    }

    public PinInfo getPinInfo(int n) {
        return this.pins[n];
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public void doSetValueAt(int n, short s) {
        this.nodes[n].set(s);
    }

    public short getValueAt(int n) {
        return this.nodes[n].get();
    }

    public void refreshGUI() {
        if (this.displayChanges) {
            for (int i = 0; i < this.pins.length; ++i) {
                this.pins[i].value = this.nodes[i].get();
            }
            this.gui.setContents(this.pins);
        }
    }

    public void reset() {
        this.gui.reset();
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].set((short)0);
        }
        this.refreshGUI();
    }

    public int getCount() {
        return this.nodes.length;
    }

    public boolean isLegalWidth(int n, short s) {
        int n2 = this.pins[n].width;
        int n3 = s > 0 ? (int)(Math.log(s) / Math.log(2.0)) + 1 : 1;
        return n3 <= n2;
    }

    public void valueChanged(ComputerPartEvent computerPartEvent) {
        this.clearErrorListeners();
        int n = computerPartEvent.getIndex();
        short s = computerPartEvent.getValue();
        if (this.isLegalWidth(n, s)) {
            this.setValueAt(n, s, true);
        } else {
            this.notifyErrorListeners("Value doesn't match the pin's width");
            this.quietUpdateGUI(n, this.nodes[computerPartEvent.getIndex()].get());
        }
    }
}

