/*
 * Decompiled with CFR 0.152.
 */
package Hack.HardwareSimulator;

import Hack.ComputerParts.ComputerPartErrorEvent;
import Hack.ComputerParts.ComputerPartErrorEventListener;
import Hack.ComputerParts.TextFileEvent;
import Hack.ComputerParts.TextFileEventListener;
import Hack.Controller.CommandException;
import Hack.Controller.HackSimulator;
import Hack.Controller.HackSimulatorGUI;
import Hack.Controller.ProgramException;
import Hack.Controller.VariableException;
import Hack.Gates.BuiltInGateClass;
import Hack.Gates.BuiltInGateWithGUI;
import Hack.Gates.CompositeGate;
import Hack.Gates.CompositeGateClass;
import Hack.Gates.DirtyGateListener;
import Hack.Gates.Gate;
import Hack.Gates.GateClass;
import Hack.Gates.GateErrorEvent;
import Hack.Gates.GateErrorEventListener;
import Hack.Gates.GateException;
import Hack.Gates.GatesManager;
import Hack.Gates.HDLException;
import Hack.Gates.Node;
import Hack.HardwareSimulator.HDLLineTokenizer;
import Hack.HardwareSimulator.HardwareSimulatorGUI;
import Hack.HardwareSimulator.PartPins;
import Hack.HardwareSimulator.Parts;
import Hack.HardwareSimulator.Pins;
import Hack.Utilities.Conversions;
import java.io.File;

public class HardwareSimulator
extends HackSimulator
implements TextFileEventListener,
GateErrorEventListener,
DirtyGateListener {
    private static final String VAR_TIME = "time";
    private static final String COMMAND_TICK = "tick";
    private static final String COMMAND_TOCK = "tock";
    private static final String COMMAND_LOAD = "load";
    private static final String COMMAND_EVAL = "eval";
    private static final String COMMAND_SETVAR = "set";
    private static final File INITIAL_BUILTIN_DIR = new File("builtInChips");
    private static final short NULL_VALUE = 0;
    private HardwareSimulatorGUI gui;
    private Gate gate;
    private Pins inputPins;
    private Pins outputPins;
    private Pins internalPins;
    private PartPins partPins;
    private Parts parts;
    private boolean clockUp;
    private int time;
    private int animationMode;
    private String[] vars;

    public HardwareSimulator() {
        this.init();
        GatesManager.getInstance().enableChipsGUI(false);
    }

    public HardwareSimulator(HardwareSimulatorGUI hardwareSimulatorGUI) {
        this.gui = hardwareSimulatorGUI;
        this.init();
        if (hardwareSimulatorGUI.getGatesPanel() != null) {
            GatesManager.getInstance().setGatesPanel(hardwareSimulatorGUI.getGatesPanel());
        }
        this.inputPins = new Pins(1, hardwareSimulatorGUI.getInputPins());
        this.outputPins = new Pins(2, hardwareSimulatorGUI.getOutputPins());
        this.internalPins = new Pins(3, hardwareSimulatorGUI.getInternalPins());
        this.partPins = new PartPins(hardwareSimulatorGUI.getPartPins());
        this.parts = new Parts(hardwareSimulatorGUI.getParts());
        this.inputPins.enableUserInput();
        this.inputPins.setNullValue((short)0, false);
        this.inputPins.addErrorListener((ComputerPartErrorEventListener)this);
        this.outputPins.disableUserInput();
        this.outputPins.setNullValue((short)0, false);
        this.internalPins.disableUserInput();
        this.internalPins.setNullValue((short)0, false);
        this.partPins.setNullValue((short)0, false);
        if (hardwareSimulatorGUI.getHDLView() != null) {
            hardwareSimulatorGUI.getHDLView().addTextFileListener((TextFileEventListener)this);
        }
        if (hardwareSimulatorGUI.getGateInfo() != null) {
            hardwareSimulatorGUI.getGateInfo().reset();
        }
        hardwareSimulatorGUI.hideInternalPins();
        hardwareSimulatorGUI.hidePartPins();
        hardwareSimulatorGUI.hideParts();
    }

    private void init() {
        Gate.CLOCK_NODE.set((short)1);
        this.clockUp = false;
        this.time = 0;
        GatesManager.getInstance().setErrorHandler(this);
        GatesManager.getInstance().setBuiltInDir(INITIAL_BUILTIN_DIR);
        this.vars = new String[]{VAR_TIME};
    }

    public String getName() {
        return "Hardware Simulator";
    }

    public String getValue(String string) throws VariableException {
        String string2 = null;
        if (this.gate == null) {
            throw new VariableException("cannot get var's value since no gate is currently loaded", string);
        }
        if (string.equals(VAR_TIME)) {
            string2 = String.valueOf(this.time) + (this.clockUp ? "+" : " ");
        } else {
            Node node = this.gate.getNode(string);
            if (node != null) {
                string2 = String.valueOf(node.get());
            } else {
                String string3 = this.getVarChipName(string);
                if (string3 != null) {
                    int n = this.getVarIndex(string);
                    BuiltInGateWithGUI builtInGateWithGUI = this.getGUIChip(string3);
                    if (builtInGateWithGUI != null) {
                        try {
                            string2 = String.valueOf(builtInGateWithGUI.getValueAt(n));
                        }
                        catch (GateException gateException) {
                            throw new VariableException(gateException.getMessage(), string);
                        }
                    } else {
                        throw new VariableException("No such built-in chip used", string3);
                    }
                }
                if (string2 == null) {
                    throw new VariableException("Unknown variable", string);
                }
            }
        }
        return string2;
    }

    private BuiltInGateWithGUI getGUIChip(String string) {
        BuiltInGateWithGUI builtInGateWithGUI = null;
        BuiltInGateWithGUI[] builtInGateWithGUIArray = GatesManager.getInstance().getChips();
        for (int i = 0; i < builtInGateWithGUIArray.length && builtInGateWithGUI == null; ++i) {
            if (!builtInGateWithGUIArray[i].getGateClass().getName().equals(string)) continue;
            builtInGateWithGUI = builtInGateWithGUIArray[i];
        }
        return builtInGateWithGUI;
    }

    private String getVarChipName(String string) {
        String string2 = null;
        int n = string.indexOf("[");
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private int getVarIndex(String string) throws VariableException {
        int n;
        if (string.endsWith("[]")) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(string.substring(string.indexOf("[") + 1, string.indexOf("]")));
            }
            catch (Exception exception) {
                throw new VariableException("Illegal component index", string);
            }
        }
        return n;
    }

    public void setValue(String string, String string2) throws VariableException {
        short s;
        if (this.gate == null) {
            throw new VariableException("cannot get var's value since no gate is currently loaded", string);
        }
        try {
            string2 = Conversions.toDecimalForm((String)string2);
            s = Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VariableException("'" + string2 + "' is not a legal value for variable", string);
        }
        boolean bl = false;
        if (string.equals(VAR_TIME)) {
            bl = true;
        } else {
            Node node = this.gate.getNode(string);
            if (node != null) {
                byte by = this.gate.getGateClass().getPinType(string);
                if (by != 1) {
                    bl = true;
                } else {
                    if (!this.isLegalWidth(string, s)) {
                        throw new VariableException(string2 + " doesn't fit in the pin's width", string);
                    }
                    node.set(s);
                }
            } else {
                boolean bl2 = false;
                String string3 = this.getVarChipName(string);
                if (string3 != null) {
                    int n = this.getVarIndex(string);
                    BuiltInGateWithGUI builtInGateWithGUI = this.getGUIChip(string3);
                    if (builtInGateWithGUI != null) {
                        try {
                            builtInGateWithGUI.setValueAt(n, s);
                            bl2 = true;
                        }
                        catch (GateException gateException) {
                            throw new VariableException(gateException.getMessage(), string);
                        }
                    } else {
                        throw new VariableException("No such built-in chip used", string3);
                    }
                }
                if (!bl2) {
                    throw new VariableException("Unknown variable", string);
                }
            }
        }
        if (bl) {
            throw new VariableException("Read Only variable", string);
        }
    }

    private boolean isLegalWidth(String string, short s) {
        byte by = this.gate.getGateClass().getPinInfo((String)string).width;
        byte by2 = (byte)(s > 0 ? (int)(Math.log(s) / Math.log(2.0)) + 1 : 1);
        return by2 <= by;
    }

    public void doCommand(String[] stringArray) throws CommandException, ProgramException, VariableException {
        if (stringArray.length == 0) {
            throw new CommandException("Empty command", stringArray);
        }
        if (stringArray[0].equals(COMMAND_TICK)) {
            if (stringArray.length != 1) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            if (this.gate == null) {
                throw new CommandException("Illegal command since no gate is currently loaded", stringArray);
            }
            if (this.clockUp) {
                throw new CommandException("Illegal command since clock is already up", stringArray);
            }
            this.performTick();
        } else if (stringArray[0].equals(COMMAND_TOCK)) {
            if (stringArray.length != 1) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            if (this.gate == null) {
                throw new CommandException("Illegal command since no gate is currently loaded", stringArray);
            }
            if (!this.clockUp) {
                throw new CommandException("Illegal command since clock is already down", stringArray);
            }
            this.performTock();
        } else if (stringArray[0].equals(COMMAND_EVAL)) {
            if (stringArray.length != 1) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            if (this.gate == null) {
                throw new CommandException("Illegal command since no gate is currently loaded", stringArray);
            }
            this.performEval();
        } else if (stringArray[0].equals(COMMAND_SETVAR)) {
            if (stringArray.length != 3) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            this.setValue(stringArray[1], stringArray[2]);
        } else {
            if (stringArray[0].equals(COMMAND_LOAD)) {
                if (stringArray.length != 2) {
                    throw new CommandException("Illegal number of arguments to command", stringArray);
                }
                if (this.gui != null && this.gui.getGateInfo() != null) {
                    this.gui.getGateInfo().setChip(stringArray[1]);
                }
                try {
                    if (!stringArray[1].endsWith(".hdl")) {
                        throw new CommandException("A .hdl file is expected", stringArray);
                    }
                    if (stringArray[1].indexOf("/") >= 0) {
                        throw new CommandException("The gate name must not contain path specification", stringArray);
                    }
                    String string = stringArray[1].substring(0, stringArray[1].length() - 4);
                    this.loadGate(string, false);
                    this.notifyProgramListeners((byte)1, GatesManager.getInstance().getHDLFileName(string));
                }
                catch (GateException gateException) {
                    throw new CommandException(gateException.getMessage(), stringArray);
                }
            }
            boolean bl = false;
            BuiltInGateWithGUI builtInGateWithGUI = this.getGUIChip(stringArray[0]);
            if (builtInGateWithGUI != null) {
                bl = true;
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                try {
                    builtInGateWithGUI.doCommand(stringArray2);
                }
                catch (GateException gateException) {
                    throw new CommandException(gateException.getMessage(), stringArray);
                }
            }
            if (!bl) {
                throw new CommandException("Unknown command or component name", stringArray);
            }
        }
    }

    public void setWorkingDir(File file) {
        super.setWorkingDir(file);
        GatesManager.getInstance().setWorkingDir(file.getParentFile());
    }

    private void hideHighlightes() {
        this.inputPins.hideHighlight();
        this.outputPins.hideHighlight();
        this.internalPins.hideHighlight();
        this.partPins.hideHighlight();
    }

    public void setAnimationSpeed(int n) {
    }

    public void refresh() {
        this.inputPins.refreshGUI();
        this.outputPins.refreshGUI();
        this.internalPins.refreshGUI();
        this.partPins.refreshGUI();
        this.parts.refreshGUI();
    }

    public void restart() {
        if (this.gui != null) {
            this.inputPins.reset();
            this.outputPins.reset();
            this.internalPins.reset();
            this.partPins.reset();
            this.parts.reset();
            if (this.gui.getHDLView() != null) {
                this.gui.getHDLView().hideSelect();
                this.gui.getHDLView().clearHighlights();
            }
            if (this.gui.getGateInfo() != null) {
                this.gui.getGateInfo().reset();
            }
            this.hideHighlightes();
        }
        if (this.gate != null) {
            this.gate.eval();
        }
        this.time = 0;
        Gate.CLOCK_NODE.set((short)1);
        this.clockUp = false;
    }

    public String[] getVariables() {
        return this.vars;
    }

    public void setAnimationMode(int n) {
        if (this.gui != null) {
            if (n == 2 && this.animationMode != 2) {
                this.inputPins.disableUserInput();
            }
            if (n != 2 && this.animationMode == 2) {
                this.inputPins.enableUserInput();
            }
            this.animationMode = n;
            boolean bl = this.animationMode == 1;
            this.inputPins.setAnimate(bl);
            this.outputPins.setAnimate(bl);
            this.internalPins.setAnimate(bl);
            this.partPins.setAnimate(bl);
            boolean bl2 = this.animationMode != 2;
            this.inputPins.setDisplayChanges(bl2);
            this.outputPins.setDisplayChanges(bl2);
            this.internalPins.setDisplayChanges(bl2);
            this.partPins.setDisplayChanges(bl2);
        }
    }

    public int getInitialAnimationMode() {
        return 0;
    }

    public int getInitialNumericFormat() {
        return 0;
    }

    public void setNumericFormat(int n) {
        this.inputPins.setNumericFormat(n);
        this.outputPins.setNumericFormat(n);
        this.internalPins.setNumericFormat(n);
        this.partPins.setNumericFormat(n);
    }

    public void prepareFastForward() {
    }

    public void prepareGUI() {
    }

    protected HackSimulatorGUI getGUI() {
        return this.gui;
    }

    protected synchronized void loadGate(String string, boolean bl) throws GateException {
        GateClass gateClass = null;
        if (this.gui != null) {
            this.displayMessage("Loading chip...", false);
        }
        try {
            GateClass.clearGateCache();
            gateClass = GateClass.getGateClass(string, bl);
            GatesManager.getInstance().removeAllChips();
            Gate gate = this.gate;
            this.gate = gateClass.newInstance();
            this.gate.addDirtyGateListener(this);
            if (gate != null) {
                gate.removeDirtyGateListener(this);
            }
            if (this.gui != null) {
                this.inputPins.setNodes(this.gate.getInputNodes(), gateClass);
                this.outputPins.setNodes(this.gate.getOutputNodes(), gateClass);
                if (gateClass instanceof CompositeGateClass) {
                    this.internalPins.setNodes(((CompositeGate)this.gate).getInternalNodes(), gateClass);
                    this.partPins.setGate(this.gate);
                    this.parts.setParts(((CompositeGate)this.gate).getParts());
                }
            }
            this.restart();
            if (this.gui != null) {
                if (this.gui.getGateInfo() != null) {
                    this.gui.getGateInfo().setChip(gateClass.getName());
                }
                this.notifyListeners((byte)107, null);
                this.gui.getOutputPins().setDimmed(false);
                this.gui.getInternalPins().setDimmed(false);
                if (gateClass.isClocked()) {
                    this.notifyListeners((byte)106, null);
                    if (this.gui.getGateInfo() != null) {
                        this.gui.getGateInfo().setClocked(gateClass.isClocked());
                        this.gui.getGateInfo().enableTime();
                    }
                } else {
                    this.notifyListeners((byte)105, null);
                    if (this.gui.getGateInfo() != null) {
                        this.gui.getGateInfo().disableTime();
                    }
                }
                if (this.gui.getHDLView() != null) {
                    if (bl) {
                        this.gui.getHDLView().setContents(string);
                    } else {
                        this.gui.getHDLView().setContents(GatesManager.getInstance().getHDLFileName(string));
                    }
                }
                if (gateClass instanceof BuiltInGateClass) {
                    this.gui.hideInternalPins();
                } else {
                    this.gui.showInternalPins();
                }
                this.gui.hidePartPins();
                this.gui.hideParts();
            }
        }
        catch (HDLException hDLException) {
            throw new GateException(hDLException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new GateException(instantiationException.getMessage());
        }
        if (this.gui != null) {
            this.clearMessage();
        }
    }

    public void rowSelected(TextFileEvent textFileEvent) {
        if (this.gate instanceof CompositeGate) {
            String string = textFileEvent.getRowString();
            boolean bl = false;
            boolean bl2 = false;
            try {
                HDLLineTokenizer hDLLineTokenizer = new HDLLineTokenizer(string);
                if (hDLLineTokenizer.hasMoreTokens()) {
                    hDLLineTokenizer.advance();
                    if (hDLLineTokenizer.getTokenType() == 1 && hDLLineTokenizer.getKeywordType() == 6) {
                        bl2 = true;
                    } else if (hDLLineTokenizer.getTokenType() == 3) {
                        String string2 = hDLLineTokenizer.getIdentifier();
                        hDLLineTokenizer.advance();
                        if (hDLLineTokenizer.getTokenType() == 2 && hDLLineTokenizer.getSymbol() == '(' && GateClass.gateClassExists(string2)) {
                            GateClass gateClass = GateClass.getGateClass(string2, false);
                            this.partPins.setPart(gateClass, string2);
                            bl = true;
                            boolean bl3 = false;
                            while (!bl3) {
                                hDLLineTokenizer.advance();
                                String string3 = hDLLineTokenizer.getIdentifier();
                                hDLLineTokenizer.advance();
                                hDLLineTokenizer.advance();
                                String string4 = hDLLineTokenizer.getIdentifier();
                                this.partPins.addPin(string3, string4);
                                hDLLineTokenizer.advance();
                                if (hDLLineTokenizer.getTokenType() != 2 || hDLLineTokenizer.getSymbol() != ')') continue;
                                bl3 = true;
                            }
                        }
                    }
                }
            }
            catch (HDLException hDLException) {
                this.displayMessage(hDLException.getMessage(), true);
            }
            if (bl) {
                this.gui.hideInternalPins();
                this.gui.hideParts();
                this.gui.showPartPins();
            } else if (bl2) {
                this.gui.hideInternalPins();
                this.gui.hidePartPins();
                this.gui.showParts();
            } else {
                this.gui.hidePartPins();
                this.gui.hideParts();
                this.gui.showInternalPins();
            }
        }
    }

    public void computerPartErrorOccured(ComputerPartErrorEvent computerPartErrorEvent) {
        this.displayMessage(computerPartErrorEvent.getErrorMessage(), true);
    }

    public void gateErrorOccured(GateErrorEvent gateErrorEvent) {
        this.displayMessage(gateErrorEvent.getErrorMessage(), true);
    }

    public void gotDirty() {
        this.notifyListeners((byte)108, null);
        if (this.gui != null) {
            this.gui.getOutputPins().setDimmed(true);
            this.gui.getInternalPins().setDimmed(true);
        }
    }

    public void gotClean() {
        this.notifyListeners((byte)107, null);
        if (this.gui != null) {
            this.gui.getOutputPins().setDimmed(false);
            this.gui.getInternalPins().setDimmed(false);
        }
    }

    private void performEval() {
        this.gate.eval();
    }

    protected void runEvalTask() {
        Thread thread = new Thread(new EvalTask());
        thread.start();
    }

    protected void runTickTockTask() {
        if (this.clockUp) {
            Thread thread = new Thread(new TockTask());
            thread.start();
        } else {
            Thread thread = new Thread(new TickTask());
            thread.start();
        }
    }

    private void performTick() {
        Gate.CLOCK_NODE.set((short)0);
        this.gate.tick();
        this.clockUp = true;
        if (this.gui != null) {
            if (this.animationMode != 2) {
                this.hideHighlightes();
            }
            this.updateTime();
        }
    }

    private void performTock() {
        Gate.CLOCK_NODE.set((short)1);
        this.gate.tock();
        this.clockUp = false;
        ++this.time;
        if (this.gui != null) {
            this.updateTime();
        }
    }

    private void updateTime() {
        if (this.gui != null && this.gui.getGateInfo() != null) {
            this.gui.getGateInfo().setClock(this.clockUp);
            if (!this.clockUp) {
                this.gui.getGateInfo().setTime(this.time);
            }
        }
    }

    private static short getIndex(String string) throws VariableException {
        if (string.indexOf("]") == -1) {
            throw new VariableException("Missing ']'", string);
        }
        String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]"));
        int n = Integer.parseInt(string2);
        if (n < 0) {
            throw new VariableException("Illegal variable index", string);
        }
        return (short)n;
    }

    public static String getFullPinName(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (byArray != null && !string.equals(CompositeGateClass.TRUE_NODE_INFO.name) && !string.equals(CompositeGateClass.FALSE_NODE_INFO.name)) {
            stringBuffer.append("[");
            stringBuffer.append(byArray[0]);
            if (byArray[0] != byArray[1]) {
                stringBuffer.append(".." + byArray[1]);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    class TockTask
    implements Runnable {
        TockTask() {
        }

        public void run() {
            HardwareSimulator.this.performTock();
        }
    }

    class TickTask
    implements Runnable {
        TickTask() {
        }

        public void run() {
            HardwareSimulator.this.performTick();
        }
    }

    class EvalTask
    implements Runnable {
        EvalTask() {
        }

        public void run() {
            HardwareSimulator.this.performEval();
        }
    }
}

