/*
 * Decompiled with CFR 0.152.
 */
package Hack.Gates;

import Hack.Gates.BuiltInGateWithGUI;
import Hack.Gates.CompositeGate;
import Hack.Gates.Connection;
import Hack.Gates.ConnectionSet;
import Hack.Gates.DirtyGateAdapter;
import Hack.Gates.Gate;
import Hack.Gates.GateClass;
import Hack.Gates.HDLException;
import Hack.Gates.HDLTokenizer;
import Hack.Gates.Node;
import Hack.Gates.PinInfo;
import Hack.Gates.SubBusListeningAdapter;
import Hack.Gates.SubNode;
import Hack.Utilities.Graph;
import java.util.Iterator;
import java.util.Vector;

public class CompositeGateClass
extends GateClass {
    public static final byte INTERNAL_PIN_TYPE = 3;
    public static final PinInfo TRUE_NODE_INFO = new PinInfo("true", 16);
    public static final PinInfo FALSE_NODE_INFO = new PinInfo("false", 16);
    public static final PinInfo CLOCK_NODE_INFO = new PinInfo("clk", 1);
    protected Vector internalPinsInfo;
    private Vector partsList = new Vector();
    private int[] partsOrder;
    private ConnectionSet connections;

    public CompositeGateClass(String string, HDLTokenizer hDLTokenizer, PinInfo[] pinInfoArray, PinInfo[] pinInfoArray2) throws HDLException {
        super(string, pinInfoArray, pinInfoArray2);
        int n;
        this.internalPinsInfo = new Vector();
        this.connections = new ConnectionSet();
        this.isInputClocked = new boolean[pinInfoArray.length];
        this.isOutputClocked = new boolean[pinInfoArray2.length];
        this.readParts(hDLTokenizer);
        Graph graph = this.createConnectionsGraph();
        Object[] objectArray = graph.topologicalSort((Object)this.partsList);
        if (graph.hasCircle()) {
            throw new HDLException("This chip has a circle in its parts connections");
        }
        this.partsOrder = new int[this.partsList.size()];
        int n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (!(objectArray[n] instanceof Integer)) continue;
            this.partsOrder[n2++] = (Integer)objectArray[n];
        }
        for (n = 0; n < pinInfoArray.length; ++n) {
            this.isInputClocked[n] = !graph.pathExists((Object)pinInfoArray[n], (Object)pinInfoArray2);
        }
        for (n = 0; n < pinInfoArray2.length; ++n) {
            this.isOutputClocked[n] = !graph.pathExists((Object)pinInfoArray, (Object)pinInfoArray2[n]);
        }
    }

    private void readParts(HDLTokenizer hDLTokenizer) throws HDLException {
        Object object;
        Object object2;
        boolean bl = false;
        while (hDLTokenizer.hasMoreTokens() && !bl) {
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() == 2 && hDLTokenizer.getSymbol() == '}') {
                bl = true;
                continue;
            }
            if (hDLTokenizer.getTokenType() != 3) {
                hDLTokenizer.HDLError("A GateClass name is expected");
            }
            object2 = hDLTokenizer.getIdentifier();
            object = CompositeGateClass.getGateClass((String)object2, false);
            this.partsList.addElement(object);
            this.isClocked = this.isClocked || ((GateClass)object).isClocked;
            int n = this.partsList.size() - 1;
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != '(') {
                hDLTokenizer.HDLError("Missing '('");
            }
            this.readPinNames(hDLTokenizer, n, (String)object2);
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() == 2 && hDLTokenizer.getSymbol() == ';') continue;
            hDLTokenizer.HDLError("Missing ';'");
        }
        if (!bl) {
            hDLTokenizer.HDLError("Missing '}'");
        }
        if (hDLTokenizer.hasMoreTokens()) {
            hDLTokenizer.HDLError("Expected end-of-file after '}'");
        }
        object2 = new boolean[this.internalPinsInfo.size()];
        object = this.connections.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)object.next();
            if (connection.getType() != 2) continue;
            object2[connection.getGatePinNumber()] = true;
        }
        for (int i = 0; i < ((boolean[])object2).length; ++i) {
            if (object2[i]) continue;
            hDLTokenizer.HDLError(((PinInfo)this.internalPinsInfo.elementAt((int)i)).name + " has no source pin");
        }
    }

    private void readPinNames(HDLTokenizer hDLTokenizer, int n, String string) throws HDLException {
        boolean bl = false;
        while (!bl) {
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() != 3) {
                hDLTokenizer.HDLError("A pin name is expected");
            }
            String string2 = hDLTokenizer.getIdentifier();
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != '=') {
                hDLTokenizer.HDLError("Missing '='");
            }
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() != 3) {
                hDLTokenizer.HDLError("A pin name is expected");
            }
            String string3 = hDLTokenizer.getIdentifier();
            this.addConnection(hDLTokenizer, n, string, string2, string3);
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() == 2 && hDLTokenizer.getSymbol() == ')') {
                bl = true;
                continue;
            }
            if (hDLTokenizer.getTokenType() == 2 && hDLTokenizer.getSymbol() == ',') continue;
            hDLTokenizer.HDLError("',' or ')' are expected");
        }
    }

    private static byte[] getSubBusAndCheck(HDLTokenizer hDLTokenizer, String string, int n) throws HDLException {
        byte[] byArray = null;
        try {
            byArray = CompositeGateClass.getSubBus(string);
        }
        catch (Exception exception) {
            hDLTokenizer.HDLError(string + " has an invalid sub bus specification");
        }
        if (byArray != null) {
            if (byArray[0] < 0 || byArray[1] < 0) {
                hDLTokenizer.HDLError(string + ": negative bit numbers are illegal");
            } else if (byArray[0] > byArray[1]) {
                hDLTokenizer.HDLError(string + ": left bit number should be lower than the right one");
            } else if (byArray[1] >= n) {
                hDLTokenizer.HDLError(string + ": the specified sub bus is not in the bus range");
            }
        }
        return byArray;
    }

    public static byte[] getSubBus(String string) throws Exception {
        byte[] byArray = null;
        int n = string.indexOf("[");
        if (n >= 0) {
            byArray = new byte[2];
            String string2 = null;
            int n2 = string.indexOf("..");
            if (n2 >= 0) {
                string2 = string.substring(n + 1, n2);
                byArray[0] = Byte.parseByte(string2);
                string2 = string.substring(n2 + 2, string.indexOf("]"));
                byArray[1] = Byte.parseByte(string2);
            } else {
                string2 = string.substring(n + 1, string.indexOf("]"));
                byArray[0] = Byte.parseByte(string2);
                byArray[1] = byArray[0];
            }
        }
        return byArray;
    }

    private void addConnection(HDLTokenizer hDLTokenizer, int n, String string, String string2, String string3) throws HDLException {
        byte[] byArray;
        int n2;
        PinInfo pinInfo;
        GateClass gateClass = (GateClass)this.partsList.elementAt(n);
        byte by = 0;
        int n3 = string2.indexOf("[");
        String string4 = n3 >= 0 ? string2.substring(0, n3) : string2;
        byte by2 = gateClass.getPinType(string4);
        if (by2 == 0) {
            hDLTokenizer.HDLError(string4 + " is not a pin in " + string);
        }
        int n4 = gateClass.getPinNumber(string4);
        PinInfo pinInfo2 = gateClass.getPinInfo(by2, n4);
        byte[] byArray2 = CompositeGateClass.getSubBusAndCheck(hDLTokenizer, string2, pinInfo2.width);
        int n5 = (byte)(byArray2 == null ? pinInfo2.width : (byte)(byArray2[1] - byArray2[0] + 1));
        n3 = string3.indexOf("[");
        String string5 = n3 >= 0 ? string3.substring(0, n3) : string3;
        int n6 = 0;
        byte by3 = 0;
        boolean bl = false;
        if (string5.equals(CompositeGateClass.TRUE_NODE_INFO.name)) {
            pinInfo = TRUE_NODE_INFO;
            by = 6;
            bl = true;
        } else if (string5.equals(CompositeGateClass.FALSE_NODE_INFO.name)) {
            pinInfo = FALSE_NODE_INFO;
            by = 7;
            bl = true;
        } else if (string5.equals(CompositeGateClass.CLOCK_NODE_INFO.name)) {
            pinInfo = CLOCK_NODE_INFO;
            by = 8;
        } else {
            by3 = this.getPinType(string5);
            if (!(by3 != 0 && by3 != 3 || string3.equals(string5))) {
                hDLTokenizer.HDLError(string3 + ": sub bus of an internal node may not be used");
            }
            if (by3 == 0) {
                by3 = 3;
                pinInfo = new PinInfo();
                pinInfo.name = string5;
                pinInfo.width = (byte)n5;
                this.internalPinsInfo.addElement(pinInfo);
                n6 = this.internalPinsInfo.size() - 1;
                this.registerPin(pinInfo, (byte)3, n6);
            } else {
                n6 = this.getPinNumber(string5);
                pinInfo = this.getPinInfo(by3, n6);
            }
        }
        if (bl) {
            if (!string5.equals(string3)) {
                hDLTokenizer.HDLError(string5 + " may not be subscripted");
            }
            n2 = n5;
            byArray = new byte[]{0, (byte)(n2 - 1)};
        } else {
            byArray = CompositeGateClass.getSubBusAndCheck(hDLTokenizer, string3, pinInfo.width);
            int n7 = n2 = byArray == null ? pinInfo.width : byArray[1] - byArray[0] + 1;
        }
        if (n5 != n2) {
            hDLTokenizer.HDLError(string4 + "(" + n5 + ") and " + string5 + "(" + n2 + ") have different bus widths");
        }
        if (by3 == 3 && by2 == 2) {
            if (pinInfo.isInitialized(byArray)) {
                hDLTokenizer.HDLError("An internal pin may only be fed once by a part's output pin");
            } else {
                pinInfo.initialize(byArray);
            }
        }
        if (by3 == 2 && by2 == 2) {
            if (pinInfo.isInitialized(byArray)) {
                hDLTokenizer.HDLError("An output pin may only be fed once by a part's output pin");
            } else {
                pinInfo.initialize(byArray);
            }
        }
        block0 : switch (by2) {
            case 1: {
                switch (by3) {
                    case 1: {
                        by = 1;
                        break;
                    }
                    case 3: {
                        by = 3;
                        break;
                    }
                    case 2: {
                        hDLTokenizer.HDLError("Can't connect gate's output pin to part");
                    }
                }
                break;
            }
            case 2: {
                switch (by3) {
                    case 1: {
                        hDLTokenizer.HDLError("Can't connect part's output pin to gate's input pin");
                    }
                    case 3: {
                        by = 2;
                        break block0;
                    }
                    case 2: {
                        by = 5;
                    }
                }
            }
        }
        Connection connection = new Connection(by, n6, n, string4, byArray, byArray2);
        this.connections.add(connection);
    }

    private Graph createConnectionsGraph() {
        int n;
        Graph graph = new Graph();
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            Integer n2 = new Integer(connection.getPartNumber());
            int n3 = connection.getGatePinNumber();
            switch (connection.getType()) {
                case 2: {
                    if (!this.isLegalFromPartEdge(connection, n2)) break;
                    graph.addEdge((Object)n2, (Object)this.getPinInfo((byte)3, n3));
                    break;
                }
                case 3: {
                    if (!this.isLegalToPartEdge(connection, n2)) break;
                    graph.addEdge((Object)this.getPinInfo((byte)3, n3), (Object)n2);
                    break;
                }
                case 5: {
                    if (!this.isLegalFromPartEdge(connection, n2)) break;
                    graph.addEdge((Object)n2, (Object)this.getPinInfo((byte)2, n3));
                    break;
                }
                case 1: {
                    if (!this.isLegalToPartEdge(connection, n2)) break;
                    graph.addEdge((Object)this.getPinInfo((byte)1, n3), (Object)n2);
                    break;
                }
                case 6: {
                    if (!this.isLegalToPartEdge(connection, n2)) break;
                    graph.addEdge((Object)TRUE_NODE_INFO, (Object)n2);
                    break;
                }
                case 7: {
                    if (!this.isLegalToPartEdge(connection, n2)) break;
                    graph.addEdge((Object)FALSE_NODE_INFO, (Object)n2);
                    break;
                }
                case 8: {
                    if (!this.isLegalToPartEdge(connection, n2)) break;
                    graph.addEdge((Object)CLOCK_NODE_INFO, (Object)n2);
                }
            }
        }
        for (n = 0; n < this.partsList.size(); ++n) {
            graph.addEdge((Object)this.partsList, (Object)new Integer(n));
        }
        for (n = 0; n < this.outputPinsInfo.length; ++n) {
            graph.addEdge((Object)this.outputPinsInfo[n], (Object)this.outputPinsInfo);
        }
        for (n = 0; n < this.inputPinsInfo.length; ++n) {
            graph.addEdge((Object)this.inputPinsInfo, (Object)this.inputPinsInfo[n]);
        }
        return graph;
    }

    private boolean isLegalToPartEdge(Connection connection, Integer n) {
        GateClass gateClass = (GateClass)this.partsList.elementAt(n);
        int n2 = gateClass.getPinNumber(connection.getPartPinName());
        return !gateClass.isInputClocked[n2];
    }

    private boolean isLegalFromPartEdge(Connection connection, Integer n) {
        GateClass gateClass = (GateClass)this.partsList.elementAt(n);
        int n2 = gateClass.getPinNumber(connection.getPartPinName());
        return !gateClass.isOutputClocked[n2];
    }

    public PinInfo getPinInfo(byte by, int n) {
        PinInfo pinInfo = null;
        if (by == 3) {
            if (n < this.internalPinsInfo.size()) {
                return (PinInfo)this.internalPinsInfo.elementAt(n);
            }
        } else {
            pinInfo = super.getPinInfo(by, n);
        }
        return pinInfo;
    }

    public Gate newInstance() throws InstantiationException {
        Node node;
        byte[] byArray;
        byte[] byArray2;
        int n;
        Node[] nodeArray = new Node[this.inputPinsInfo.length];
        Node[] nodeArray2 = new Node[this.outputPinsInfo.length];
        Node[] nodeArray3 = new Node[this.internalPinsInfo.size()];
        CompositeGate compositeGate = new CompositeGate();
        Gate[] gateArray = new Gate[this.partsList.size()];
        for (int i = 0; i < gateArray.length; ++i) {
            gateArray[i] = ((GateClass)this.partsList.elementAt(i)).newInstance();
            if (!(gateArray[i] instanceof BuiltInGateWithGUI)) continue;
            ((BuiltInGateWithGUI)gateArray[i]).setParent(compositeGate);
        }
        Gate[] gateArray2 = new Gate[gateArray.length];
        for (n = 0; n < gateArray.length; ++n) {
            gateArray2[n] = gateArray[this.partsOrder[n]];
        }
        for (n = 0; n < nodeArray.length; ++n) {
            nodeArray[n] = new Node();
        }
        for (n = 0; n < nodeArray2.length; ++n) {
            nodeArray2[n] = new Node();
        }
        DirtyGateAdapter dirtyGateAdapter = new DirtyGateAdapter(compositeGate);
        for (int i = 0; i < this.isInputClocked.length; ++i) {
            if (this.isInputClocked[i]) continue;
            nodeArray[i].addListener(dirtyGateAdapter);
        }
        ConnectionSet connectionSet = new ConnectionSet();
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            byArray2 = connection.getGateSubBus();
            byArray = connection.getPartSubBus();
            node = gateArray[connection.getPartNumber()].getNode(connection.getPartPinName());
            switch (connection.getType()) {
                case 1: {
                    this.connectGateToPart(nodeArray[connection.getGatePinNumber()], byArray2, node, byArray);
                    break;
                }
                case 5: {
                    this.connectGateToPart(node, byArray, nodeArray2[connection.getGatePinNumber()], byArray2);
                    break;
                }
                case 2: {
                    Node node2 = null;
                    node2 = byArray == null ? new Node() : new SubNode(byArray[0], byArray[1]);
                    node.addListener(node2);
                    nodeArray3[connection.getGatePinNumber()] = node2;
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    connectionSet.add(connection);
                }
            }
        }
        iterator = connectionSet.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            node = gateArray[connection.getPartNumber()].getNode(connection.getPartPinName());
            byArray = connection.getPartSubBus();
            byArray2 = connection.getGateSubBus();
            Node node3 = null;
            switch (connection.getType()) {
                case 3: {
                    node3 = nodeArray3[connection.getGatePinNumber()];
                    if (byArray == null) {
                        node3.addListener(node);
                        break;
                    }
                    Node node4 = new SubBusListeningAdapter(node, byArray[0], byArray[1]);
                    node3.addListener(node4);
                    break;
                }
                case 6: {
                    Node node4 = new SubNode(byArray2[0], byArray2[1]);
                    node4.set(Gate.TRUE_NODE.get());
                    if (byArray == null) {
                        node.set(((SubNode)node4).get());
                        break;
                    }
                    SubBusListeningAdapter subBusListeningAdapter = new SubBusListeningAdapter(node, byArray[0], byArray[1]);
                    ((Node)subBusListeningAdapter).set(((SubNode)node4).get());
                    break;
                }
                case 7: {
                    Node node4 = new SubNode(byArray2[0], byArray2[1]);
                    node4.set(Gate.FALSE_NODE.get());
                    if (byArray == null) {
                        node.set(((SubNode)node4).get());
                        break;
                    }
                    SubBusListeningAdapter subBusListeningAdapter = new SubBusListeningAdapter(node, byArray[0], byArray[1]);
                    ((Node)subBusListeningAdapter).set(((SubNode)node4).get());
                    break;
                }
                case 8: {
                    node.set(Gate.CLOCK_NODE.get());
                    Gate.CLOCK_NODE.addListener(node);
                    bl = true;
                }
            }
        }
        if (bl) {
            Gate.CLOCK_NODE.addListener(new DirtyGateAdapter(compositeGate));
        }
        compositeGate.init(nodeArray, nodeArray2, nodeArray3, gateArray2, this);
        return compositeGate;
    }

    private void connectGateToPart(Node node, byte[] byArray, Node node2, byte[] byArray2) {
        Node node3 = node;
        Node node4 = node2;
        if (byArray2 != null) {
            node4 = new SubBusListeningAdapter(node4, byArray2[0], byArray2[1]);
        }
        if (byArray == null) {
            node3.addListener(node4);
        } else {
            SubNode subNode = new SubNode(byArray[0], byArray[1]);
            node3.addListener(subNode);
            subNode.addListener(node4);
        }
    }
}

