/*
 * Decompiled with CFR 0.152.
 */
package Hack.Gates;

import Hack.Gates.BuiltInGate;
import Hack.Gates.BuiltInGateWithGUI;
import Hack.Gates.DirtyGateAdapter;
import Hack.Gates.Gate;
import Hack.Gates.GateClass;
import Hack.Gates.GatesManager;
import Hack.Gates.HDLException;
import Hack.Gates.HDLTokenizer;
import Hack.Gates.Node;
import Hack.Gates.PinInfo;

public class BuiltInGateClass
extends GateClass {
    private Class javaGateClass;

    public BuiltInGateClass(String string, HDLTokenizer hDLTokenizer, PinInfo[] pinInfoArray, PinInfo[] pinInfoArray2) throws HDLException {
        super(string, pinInfoArray, pinInfoArray2);
        boolean bl;
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() != 3) {
            hDLTokenizer.HDLError("Missing java class name");
        }
        String string2 = hDLTokenizer.getIdentifier();
        String string3 = GatesManager.getInstance().getBuiltInDir() + "." + string2;
        try {
            this.javaGateClass = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            hDLTokenizer.HDLError("Can't find " + string2 + " java class");
        }
        Class clazz = this.javaGateClass;
        while (!(bl = (clazz = clazz.getSuperclass()).getName().equals("Hack.Gates.BuiltInGate")) && !clazz.getName().equals("java.lang.Object")) {
        }
        if (!bl) {
            hDLTokenizer.HDLError(string2 + " is not a subclass of BuiltInGate");
        }
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != ';') {
            hDLTokenizer.HDLError("Missing ';'");
        }
        this.isInputClocked = new boolean[pinInfoArray.length];
        this.isOutputClocked = new boolean[pinInfoArray2.length];
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() == 1) {
            if (hDLTokenizer.getKeywordType() != 5) {
                hDLTokenizer.HDLError("Unexpected keyword");
            }
            this.isClocked = true;
            String[] stringArray = BuiltInGateClass.readPinNames(hDLTokenizer);
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                boolean bl2 = false;
                boolean bl3 = false;
                for (n = 0; n < this.isInputClocked.length && !bl2; ++n) {
                    if (this.isInputClocked[n]) continue;
                    this.isInputClocked[n] = bl2 = pinInfoArray[n].name.equals(stringArray[i]);
                }
                if (bl2) continue;
                for (n = 0; n < this.isOutputClocked.length && !bl3; ++n) {
                    if (this.isOutputClocked[n]) continue;
                    this.isOutputClocked[n] = bl3 = pinInfoArray2[n].name.equals(stringArray[i]);
                }
            }
            hDLTokenizer.advance();
        }
        if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != '}') {
            hDLTokenizer.HDLError("Missing '}'");
        }
    }

    public Gate newInstance() throws InstantiationException {
        BuiltInGate builtInGate;
        int n;
        Node[] nodeArray = new Node[this.inputPinsInfo.length];
        Node[] nodeArray2 = new Node[this.outputPinsInfo.length];
        for (n = 0; n < nodeArray.length; ++n) {
            nodeArray[n] = new Node();
        }
        for (n = 0; n < nodeArray2.length; ++n) {
            nodeArray2[n] = new Node();
        }
        try {
            builtInGate = (BuiltInGate)this.javaGateClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InstantiationException(illegalAccessException.getMessage());
        }
        builtInGate.init(nodeArray, nodeArray2, this);
        if (builtInGate instanceof BuiltInGateWithGUI) {
            GatesManager.getInstance().addChip((BuiltInGateWithGUI)builtInGate);
        }
        DirtyGateAdapter dirtyGateAdapter = new DirtyGateAdapter(builtInGate);
        for (int i = 0; i < this.isInputClocked.length; ++i) {
            if (this.isInputClocked[i]) continue;
            nodeArray[i].addListener(dirtyGateAdapter);
        }
        return builtInGate;
    }
}

