/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.CPUEmulator.ScreenGUI;
import Hack.ComputerParts.LabeledPointedMemoryGUI;
import Hack.ComputerParts.MemorySegment;
import Hack.ComputerParts.PointedMemory;
import Hack.ComputerParts.PointedMemoryGUI;
import Hack.ComputerParts.PointedMemorySegment;

public class RAM
extends PointedMemory {
    private static final int LABEL_FLASH_TIME = 500;
    private static final short[] emptyScreen = new short[8192];
    private ScreenGUI screen;
    private MemorySegment[][] segments;

    public RAM(PointedMemoryGUI pointedMemoryGUI, MemorySegment[][] memorySegmentArray, ScreenGUI screenGUI) {
        super(24577, pointedMemoryGUI);
        this.segments = memorySegmentArray;
        this.screen = screenGUI;
    }

    public void setValueAt(int n, short s, boolean bl) {
        super.setValueAt(n, s, bl);
        if (this.screen != null && n >= 16384 && n < 24576) {
            this.screen.setValueAt((short)(n - 16384), s);
        }
        if (this.segments != null && this.segments[n] != null) {
            for (int i = 0; i < this.segments[n].length; ++i) {
                if (this.segments[n][i] instanceof PointedMemorySegment) {
                    ((PointedMemorySegment)this.segments[n][i]).setPointerAddress((int)s);
                    continue;
                }
                this.segments[n][i].setStartAddress((int)s);
            }
        }
    }

    public synchronized void setLabel(int n, String string, boolean bl) {
        if (this.hasGUI && this.gui instanceof LabeledPointedMemoryGUI) {
            ((LabeledPointedMemoryGUI)this.gui).setLabel(n, string);
            if (!bl) {
                ((LabeledPointedMemoryGUI)this.gui).labelFlash(n);
                try {
                    ((Object)((Object)this)).wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ((LabeledPointedMemoryGUI)this.gui).hideLabelFlash();
            }
        }
    }

    public void clearLabels() {
        if (this.hasGUI && this.gui instanceof LabeledPointedMemoryGUI) {
            ((LabeledPointedMemoryGUI)this.gui).clearLabels();
        }
    }

    public void reset() {
        super.reset();
        if (this.screen != null) {
            this.screen.reset();
        }
    }

    public void clearScreen() {
        this.setContents(emptyScreen, 16384);
        if (this.screen != null) {
            this.screen.reset();
        }
    }

    public void refreshGUI() {
        super.refreshGUI();
        if (this.segments != null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.segments[i] == null) continue;
                for (int j = 0; j < this.segments[i].length; ++j) {
                    if (this.segments[i][j] instanceof PointedMemorySegment) {
                        ((PointedMemorySegment)this.segments[i][j]).setPointerAddress((int)this.mem[i]);
                        continue;
                    }
                    this.segments[i][j].setStartAddress((int)this.mem[i]);
                }
            }
        }
    }
}

