/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.PointedMemory;
import Hack.ComputerParts.Register;
import Hack.ComputerParts.RegisterGUI;

public class PointerAddressRegisterAdapter
extends Register {
    protected PointedMemory memory;
    protected boolean updatePointer;

    public PointerAddressRegisterAdapter(RegisterGUI registerGUI, PointedMemory pointedMemory) {
        super(registerGUI, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        this.memory = pointedMemory;
        this.updatePointer = true;
    }

    public void setValueAt(int n, short s, boolean bl) {
        super.setValueAt(0, s, bl);
        if (this.updatePointer) {
            this.memory.setPointerAddress((int)s);
        }
    }

    public void valueChanged(ComputerPartEvent computerPartEvent) {
        super.valueChanged(computerPartEvent);
        if (this.updatePointer) {
            this.memory.setPointerAddress((int)computerPartEvent.getValue());
        }
    }

    public void reset() {
        super.reset();
        if (this.updatePointer) {
            this.memory.setPointerAddress(0);
        }
    }

    public void refreshGUI() {
        this.quietUpdateGUI(0, this.value);
        if (this.updatePointer) {
            this.memory.setPointerAddress((int)this.value);
        }
    }

    public void setUpdatePointer(boolean bl) {
        this.updatePointer = bl;
        if (bl) {
            this.memory.setPointerAddress((int)this.value);
        }
    }
}

