/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.CPUEmulator.ALUGUI;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.ValueComputerPart;
import Hack.Utilities.Definitions;

public class ALU
extends ValueComputerPart {
    private static final int BODY_FLASH_TIME = 500;
    private static final int COMMAND_FLASH_TIME = 500;
    private short input0;
    private short input1;
    private short output;
    private String commandDescription;
    private ALUGUI gui;
    private boolean zero0;
    private boolean zero1;
    private boolean negate0;
    private boolean negate1;
    private boolean ADDorAND;
    private boolean negateOutput;

    public ALU(ALUGUI aLUGUI) {
        super(aLUGUI != null);
        this.gui = aLUGUI;
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public synchronized void setCommand(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.commandDescription = string;
        this.zero0 = bl;
        this.negate0 = bl2;
        this.zero1 = bl3;
        this.negate1 = bl4;
        this.ADDorAND = bl5;
        this.negateOutput = bl6;
        if (this.displayChanges) {
            this.gui.setCommand(string);
        }
        if (this.animate) {
            this.gui.commandFlash();
            try {
                ((Object)((Object)this)).wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.gui.hideCommandFlash();
        }
    }

    public synchronized void compute() {
        if (this.animate) {
            this.gui.bodyFlash();
            try {
                ((Object)((Object)this)).wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.gui.hideBodyFlash();
        }
        short s = Definitions.computeALU((short)this.input0, (short)this.input1, (boolean)this.zero0, (boolean)this.negate0, (boolean)this.zero1, (boolean)this.negate1, (boolean)this.ADDorAND, (boolean)this.negateOutput);
        this.setValueAt(2, s, false);
    }

    public void setInput0(short s) {
        this.setValueAt(0, s, false);
    }

    public void setInput1(short s) {
        this.setValueAt(1, s, false);
    }

    public short getOutput() {
        return this.getValueAt(2);
    }

    public short getValueAt(int n) {
        short s = 0;
        switch (n) {
            case 0: {
                s = this.input0;
                break;
            }
            case 1: {
                s = this.input1;
                break;
            }
            case 2: {
                s = this.output;
            }
        }
        return s;
    }

    public void doSetValueAt(int n, short s) {
        switch (n) {
            case 0: {
                this.input0 = s;
                break;
            }
            case 1: {
                this.input1 = s;
                break;
            }
            case 2: {
                this.output = s;
            }
        }
    }

    public void reset() {
        super.reset();
        this.input0 = this.nullValue;
        this.input1 = this.nullValue;
        this.output = this.nullValue;
    }

    public void refreshGUI() {
        this.quietUpdateGUI(0, this.input0);
        this.quietUpdateGUI(1, this.input1);
        this.quietUpdateGUI(2, this.output);
    }
}

