/*
 * Decompiled with CFR 0.152.
 */
package Hack.VirtualMachine;

import Hack.VirtualMachine.HVMInstructionSet;

public class HVMInstruction {
    private byte opCode;
    private short arg0;
    private short arg1;
    private String stringArg;
    private short numberOfArgs;

    public HVMInstruction(byte by, short s, short s2) {
        this.opCode = by;
        this.arg0 = s;
        this.arg1 = s2;
        this.numberOfArgs = (short)2;
    }

    public HVMInstruction(byte by, short s) {
        this.opCode = by;
        this.arg0 = s;
        this.numberOfArgs = 1;
    }

    public HVMInstruction(byte by) {
        this.opCode = by;
        this.numberOfArgs = 0;
    }

    public short getOpCode() {
        return this.opCode;
    }

    public short getArg0() {
        return this.arg0;
    }

    public short getArg1() {
        return this.arg1;
    }

    public void setStringArg(String string) {
        this.stringArg = string;
    }

    public String getStringArg() {
        return this.stringArg;
    }

    public short getNumberOfArgs() {
        return this.numberOfArgs;
    }

    public String[] getFormattedStrings() {
        String[] stringArray = new String[3];
        HVMInstructionSet hVMInstructionSet = HVMInstructionSet.getInstance();
        stringArray[1] = "";
        stringArray[2] = "";
        stringArray[0] = hVMInstructionSet.instructionCodeToString(this.opCode);
        if (stringArray[0] == null) {
            stringArray[0] = "";
        }
        switch (this.opCode) {
            case 10: {
                stringArray[1] = hVMInstructionSet.segmentCodeToVMString((byte)this.arg0);
                stringArray[2] = String.valueOf(this.arg1);
                break;
            }
            case 11: {
                if (this.numberOfArgs != 2) break;
                stringArray[1] = hVMInstructionSet.segmentCodeToVMString((byte)this.arg0);
                stringArray[2] = String.valueOf(this.arg1);
                break;
            }
            case 12: {
                stringArray[1] = this.stringArg;
                break;
            }
            case 13: {
                stringArray[1] = this.stringArg;
                break;
            }
            case 14: {
                stringArray[1] = this.stringArg;
                break;
            }
            case 15: {
                stringArray[1] = this.stringArg;
                stringArray[2] = String.valueOf(this.arg0);
                break;
            }
            case 17: {
                stringArray[1] = this.stringArg;
                stringArray[2] = String.valueOf(this.arg1);
            }
        }
        return stringArray;
    }

    public String toString() {
        String[] stringArray = this.getFormattedStrings();
        StringBuffer stringBuffer = new StringBuffer();
        if (!stringArray[0].equals("")) {
            stringBuffer.append(stringArray[0]);
            if (!stringArray[1].equals("")) {
                stringBuffer.append(" ");
                stringBuffer.append(stringArray[1]);
                if (!stringArray[2].equals("")) {
                    stringBuffer.append(" ");
                    stringBuffer.append(stringArray[2]);
                }
            }
        }
        return stringBuffer.toString();
    }
}

