/*
 * Decompiled with CFR 0.152.
 */
package Hack.Compiler;

import Hack.Compiler.JackException;
import Hack.Compiler.JackTokenizer;
import Hack.Compiler.SymbolTable;
import Hack.Compiler.VMWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class CompilationEngine {
    private static final int GENERAL_TYPE = 1;
    private static final int NUMERIC_TYPE = 2;
    private static final int INT_TYPE = 3;
    private static final int CHAR_TYPE = 4;
    private static final int BOOLEAN_TYPE = 5;
    private static final int STRING_TYPE = 6;
    private static final int THIS_TYPE = 7;
    private static final int NULL_TYPE = 8;
    private JackTokenizer input;
    private VMWriter output;
    private SymbolTable identifiers;
    private HashMap subroutines;
    private HashSet classes = new HashSet();
    private Vector subroutineCalls;
    private int ifCounter;
    private int whileCounter;
    private int subroutineType;
    private int[] expTypes;
    private int expIndex;
    private String fileName;
    private boolean validJack;

    CompilationEngine() {
        this.subroutines = new HashMap();
        this.subroutineCalls = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compileClass(JackTokenizer jackTokenizer, VMWriter vMWriter, String string, String string2) {
        this.input = jackTokenizer;
        this.output = vMWriter;
        this.fileName = string2;
        this.expTypes = new int[100];
        this.expIndex = -1;
        this.validJack = true;
        jackTokenizer.advance();
        String string3 = null;
        try {
            try {
                if (this.isKeywordClass()) {
                    jackTokenizer.advance();
                } else {
                    this.recoverableError("Expected 'class'", -1, "", string2);
                }
                if (this.isIdentifier()) {
                    string3 = jackTokenizer.getIdentifier();
                    if (!string3.equals(string)) {
                        this.recoverableError("The class name doesn't match the file name", -1, "", string2);
                    }
                    jackTokenizer.advance();
                } else {
                    this.recoverableError("Expected a class name", -1, "", string2);
                    string3 = string;
                }
                this.identifiers = new SymbolTable(string3);
                if (this.isSymbol('{')) {
                    jackTokenizer.advance();
                } else {
                    this.recoverableError("Expected {", -1, "", string2);
                }
                this.compileFieldAndStaticDeclarations();
                this.compileAllSubroutines();
                if (!this.isSymbol('}')) {
                    this.recoverableError("Expected }", -1, "", string2);
                }
                if (jackTokenizer.hasMoreTokens()) {
                    this.recoverableError("Expected end-of-file", -1, "", string2);
                }
            }
            catch (JackException jackException) {
                Object var8_7 = null;
                vMWriter.close();
                if (!this.validJack) return this.validJack;
                this.classes.add(string3);
                return this.validJack;
            }
            Object var8_6 = null;
            vMWriter.close();
            if (!this.validJack) return this.validJack;
            this.classes.add(string3);
            return this.validJack;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            vMWriter.close();
            if (!this.validJack) return this.validJack;
            this.classes.add(string3);
            return this.validJack;
        }
    }

    boolean verifySubroutineCalls() {
        this.validJack = true;
        Iterator iterator = this.subroutineCalls.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            String string = (String)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            short s = (Short)objectArray[2];
            String string2 = (String)objectArray[3];
            String string3 = (String)objectArray[4];
            int n = (Integer)objectArray[5];
            if (!this.classes.contains(string.substring(0, string.indexOf(".")))) continue;
            if (!this.subroutines.containsKey(string)) {
                this.recoverableError((bl ? "Method " : "Function or constructor ") + string + " doesn't exist", n, string3, string2);
                continue;
            }
            objectArray = (Object[])this.subroutines.get(string);
            int n2 = (Integer)objectArray[0];
            short s2 = (Short)objectArray[1];
            if (bl && n2 != 1) {
                this.recoverableError((n2 == 2 ? "Function " : "Constructor ") + string + " called as a method", n, string3, string2);
            } else if (!bl && n2 == 1) {
                this.recoverableError("Method " + string + " called as a function/constructor", n, string3, string2);
            }
            if (s == s2) continue;
            this.recoverableError("Subroutine " + string + " (declared to accept " + s2 + " parameter(s)) called with " + s + " parameter(s)", n, string3, string2);
        }
        return this.validJack;
    }

    private void compileAllSubroutines() throws JackException {
        while (this.isKeywordMethod() || this.isKeywordFunction() || this.isKeywordConstructor()) {
            try {
                if (this.isKeywordMethod()) {
                    this.compileMethod();
                    continue;
                }
                if (this.isKeywordFunction()) {
                    this.compileFunction();
                    continue;
                }
                this.compileConstructor();
            }
            catch (JackException jackException) {
                while (!this.isKeywordMethod() && !this.isKeywordFunction() && !this.isKeywordConstructor() && this.input.hasMoreTokens()) {
                    this.input.advance();
                }
            }
        }
    }

    private void compileMethod() throws JackException {
        this.compileSubroutine(1);
    }

    private void compileFunction() throws JackException {
        this.compileSubroutine(2);
    }

    private void compileConstructor() throws JackException {
        this.compileSubroutine(3);
    }

    private void compileSubroutine(int n) throws JackException {
        String string;
        this.subroutineType = n;
        this.ifCounter = 0;
        this.whileCounter = 0;
        this.input.advance();
        String string2 = null;
        string2 = this.isKeywordVoid() ? "void" : this.getType();
        int n2 = this.input.getLineNumber();
        this.input.advance();
        String string3 = null;
        if (this.isIdentifier()) {
            string3 = this.input.getIdentifier();
            string = this.identifiers.getClassName() + "." + string3;
            if (this.subroutines.containsKey(string)) {
                this.recoverableError("Subroutine " + string3 + " redeclared", -1, "", this.fileName);
            }
            this.input.advance();
        } else {
            this.recoverableError("Expected a type followed by a subroutine name", -1, "", this.fileName);
            string = this.identifiers.getClassName() + "." + "unknownname";
        }
        switch (n) {
            case 1: {
                this.identifiers.startMethod(string3, string2);
                break;
            }
            case 2: {
                this.identifiers.startFunction(string3, string2);
                break;
            }
            case 3: {
                this.identifiers.startConstructor(string3);
                if (string2.equals(this.identifiers.getClassName())) break;
                this.recoverableError("The return type of a constructor must be of the class type", n2);
            }
        }
        if (this.isSymbol('(')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected (");
        }
        short s = this.compileParametersList();
        this.input.advance();
        this.compileSubroutineBody(string);
        this.identifiers.endSubroutine();
        if (string3 != null) {
            this.subroutines.put(string, new Object[]{new Integer(n), new Short(s)});
        }
    }

    private void compileSubroutineBody(String string) throws JackException {
        if (this.isSymbol('{')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected {");
        }
        this.compileLocalsDeclarations();
        short s = this.identifiers.getNumberOfIdentifiers(3);
        this.output.function(string, s);
        if (this.subroutineType == 1) {
            this.output.push("argument", (short)0);
            this.output.pop("pointer", (short)0);
        } else if (this.subroutineType == 3) {
            short s2 = this.identifiers.getNumberOfIdentifiers(1);
            this.output.push("constant", s2);
            this.output.callFunction("Memory.alloc", (short)1);
            this.output.pop("pointer", (short)0);
        }
        if (this.compileStatements(true)) {
            this.recoverableError("Program flow may reach end of subroutine without 'return'");
        }
        this.input.advance();
    }

    private short compileParametersList() throws JackException {
        short s = 0;
        if (this.isSymbol(')')) {
            return s;
        }
        boolean bl = true;
        while (bl) {
            s = (short)(s + 1);
            String string = this.getType();
            this.input.advance();
            String string2 = null;
            if (this.isIdentifier()) {
                string2 = this.input.getIdentifier();
                this.input.advance();
            } else {
                this.recoverableError("Expected a type followed by a variable name");
            }
            this.identifiers.define(string2, string, 2);
            if (this.isSymbol(')')) {
                bl = false;
                continue;
            }
            if (this.isSymbol(',')) {
                this.input.advance();
                continue;
            }
            this.terminalError("Expected ) or , in parameters list");
        }
        return s;
    }

    private void compileFieldAndStaticDeclarations() throws JackException {
        boolean bl = true;
        while (bl) {
            if (this.isKeywordField()) {
                this.compileDeclarationLine(1);
                continue;
            }
            if (this.isKeywordStatic()) {
                this.compileDeclarationLine(0);
                continue;
            }
            bl = false;
        }
    }

    private void compileLocalsDeclarations() throws JackException {
        while (this.isKeywordLocal()) {
            this.compileDeclarationLine(3);
        }
    }

    private void compileDeclarationLine(int n) throws JackException {
        this.input.advance();
        String string = this.getType();
        boolean bl = true;
        while (bl) {
            this.input.advance();
            if (this.isIdentifier()) {
                this.identifiers.define(this.input.getIdentifier(), string, n);
                this.input.advance();
            } else {
                this.recoverableError("Expected a type followed by comma-seperated variable names");
            }
            if (this.isSymbol(';')) {
                this.input.advance();
                bl = false;
                continue;
            }
            if (this.isSymbol(',')) continue;
            this.terminalError("Expected , or ;");
        }
    }

    private void skipToEndOfStatement() {
        while (!this.isSymbol(';') && !this.isSymbol('}') && this.input.hasMoreTokens()) {
            this.input.advance();
        }
        if (this.isSymbol(';') && this.input.hasMoreTokens()) {
            this.input.advance();
        }
    }

    private boolean compileStatements(boolean bl) throws JackException {
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        while (!this.isSymbol('}')) {
            if (!bl && !bl2) {
                this.warning("Unreachable code");
                bl2 = true;
            }
            if (this.isKeywordDo()) {
                try {
                    this.compileDo();
                }
                catch (JackException jackException) {
                    this.skipToEndOfStatement();
                }
                continue;
            }
            if (this.isKeywordLet()) {
                try {
                    this.compileLet();
                }
                catch (JackException jackException) {
                    this.skipToEndOfStatement();
                }
                continue;
            }
            if (this.isKeywordWhile()) {
                bl = this.compileWhile(bl);
                continue;
            }
            if (this.isKeywordReturn()) {
                try {
                    this.compileReturn();
                }
                catch (JackException jackException) {
                    this.skipToEndOfStatement();
                }
                bl = false;
                continue;
            }
            if (this.isKeywordIf()) {
                bl = this.compileIf(bl);
                continue;
            }
            if (this.isSymbol(';')) {
                this.recoverableError("An empty statement is not allowed");
                this.input.advance();
                continue;
            }
            String string = "Expected statement(do, let, while, return or if)";
            if (this.isIdentifier()) {
                this.recoverableError(string);
                this.skipToEndOfStatement();
                continue;
            }
            this.terminalError(string);
        }
        return bl;
    }

    private void compileDo() throws JackException {
        this.input.advance();
        this.compileSubroutineCall();
        this.output.pop("temp", (short)0);
        if (this.isSymbol(';')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected ;");
        }
    }

    private void compileSubroutineCall() throws JackException {
        if (!this.isIdentifier()) {
            this.terminalError("Expected class name, subroutine name, field, parameter or local or static variable name");
        }
        String string = this.input.getIdentifier();
        int n = this.input.getLineNumber();
        this.input.advance();
        if (this.isSymbol('.')) {
            this.compileExternalSubroutineCall(string);
        } else {
            this.compileInternalSubroutineCall(string, n);
        }
    }

    private void compileExternalSubroutineCall(String string) throws JackException {
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        this.input.advance();
        int n = this.input.getLineNumber();
        try {
            string2 = this.identifiers.getTypeOf(string);
            int s = this.identifiers.getKindOf(string);
            short objectArray = this.identifiers.getIndexOf(string);
            this.pushVariable(s, objectArray);
        }
        catch (JackException jackException) {
            string2 = string;
            bl = false;
        }
        if (this.isIdentifier()) {
            string3 = string2 + "." + this.input.getIdentifier();
            this.input.advance();
        } else {
            this.terminalError("Expected subroutine name");
        }
        short s = this.compileExpressionList();
        this.output.callFunction(string3, (short)(s + (bl ? (short)1 : 0)));
        Object[] objectArray = new Object[]{string3, new Boolean(bl), new Short(s), this.fileName, this.identifiers.getSubroutineName(), new Integer(n)};
        this.subroutineCalls.addElement(objectArray);
    }

    private void compileInternalSubroutineCall(String string, int n) throws JackException {
        String string2 = null;
        string2 = this.identifiers.getClassName() + "." + string;
        this.output.push("pointer", (short)0);
        short s = this.compileExpressionList();
        this.output.callFunction(string2, (short)(s + 1));
        if (this.subroutineType == 2) {
            this.recoverableError("Subroutine " + string2 + " called as a method from within a function", n);
        } else {
            Object[] objectArray = new Object[]{string2, Boolean.TRUE, new Short(s), this.fileName, this.identifiers.getSubroutineName(), new Integer(n)};
            this.subroutineCalls.addElement(objectArray);
        }
    }

    private void skipFromParensToBlockStart() {
        while (!this.isSymbol(';') && !this.isSymbol('}') && !this.isSymbol('{') && this.input.hasMoreTokens()) {
            this.input.advance();
        }
    }

    private boolean compileWhile(boolean bl) throws JackException {
        int n;
        block10: {
            n = this.whileCounter++;
            this.input.advance();
            if (this.isSymbol('(')) {
                this.input.advance();
            } else {
                this.recoverableError("Expected (");
            }
            try {
                this.output.label("WHILE_EXP" + n);
                this.compileNewExpression(1);
                this.output.not();
                if (this.isSymbol(')')) {
                    this.input.advance();
                } else {
                    this.recoverableError("Expected )");
                }
            }
            catch (JackException jackException) {
                this.skipFromParensToBlockStart();
                if (this.isSymbol('{')) break block10;
                throw jackException;
            }
        }
        if (this.isSymbol('{')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected {");
        }
        this.output.ifGoTo("WHILE_END" + n);
        bl = this.compileStatements(bl);
        if (this.isSymbol('}')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected }");
        }
        this.output.goTo("WHILE_EXP" + n);
        this.output.label("WHILE_END" + n);
        return bl;
    }

    private boolean compileIf(boolean bl) throws JackException {
        int n;
        block15: {
            n = this.ifCounter++;
            this.input.advance();
            if (this.isSymbol('(')) {
                this.input.advance();
            } else {
                this.recoverableError("Expected (");
            }
            try {
                this.compileNewExpression(1);
                if (this.isSymbol(')')) {
                    this.input.advance();
                } else {
                    this.recoverableError("Expected )");
                }
            }
            catch (JackException jackException) {
                this.skipFromParensToBlockStart();
                if (this.isSymbol('{')) break block15;
                throw jackException;
            }
        }
        if (this.isSymbol('{')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected {");
        }
        this.output.ifGoTo("IF_TRUE" + n);
        this.output.goTo("IF_FALSE" + n);
        this.output.label("IF_TRUE" + n);
        boolean bl2 = this.compileStatements(bl);
        if (this.isSymbol('}')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected }");
        }
        if (!this.isKeywordElse()) {
            this.output.label("IF_FALSE" + n);
            return true;
        }
        this.input.advance();
        if (this.isSymbol('{')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected {");
        }
        this.output.goTo("IF_END" + n);
        this.output.label("IF_FALSE" + n);
        boolean bl3 = this.compileStatements(bl);
        if (this.isSymbol('}')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected }");
        }
        this.output.label("IF_END" + n);
        return bl2 || bl3;
    }

    private void compileReturn() throws JackException {
        this.input.advance();
        if (this.subroutineType == 3 && !this.isKeywordThis()) {
            this.recoverableError("A constructor must return 'this'");
        }
        if (this.isSymbol(';')) {
            if (!this.identifiers.getReturnType().equals("void")) {
                this.recoverableError("A non-void function must return a value");
            }
            this.output.push("constant", (short)0);
            this.output.returnFromFunction();
            this.input.advance();
        } else {
            if (this.identifiers.getReturnType().equals("void")) {
                this.recoverableError("A void function must not return a value");
            }
            this.compileNewExpression(1);
            this.output.returnFromFunction();
            if (this.isSymbol(';')) {
                this.input.advance();
            } else {
                this.recoverableError("Expected ;");
            }
        }
    }

    private void compileLet() throws JackException {
        String string;
        short s;
        int n;
        this.input.advance();
        if (!this.isIdentifier()) {
            this.terminalError("Expected field, parameter or local or static variable name");
        }
        String string2 = this.input.getIdentifier();
        try {
            n = this.identifiers.getKindOf(string2);
            s = this.identifiers.getIndexOf(string2);
            string = this.identifiers.getTypeOf(string2);
        }
        catch (JackException jackException) {
            this.recoverableError(string2 + " is not defined as a field, parameter or local or static variable");
            n = 0;
            s = 0;
            string = "int";
        }
        this.input.advance();
        if (this.isSymbol('=')) {
            this.input.advance();
            int n2 = this.compileNewExpression(1);
            this.popVariable(n, s);
            if (n2 != 1) {
                if (string.equals("int") && n2 != 3 && n2 != 2) {
                    this.recoverableError("an int value is expected", this.input.getLineNumber() - 1);
                } else if (string.equals("char") && n2 != 4 && n2 != 2) {
                    this.recoverableError("a char value is expected", this.input.getLineNumber() - 1);
                } else if (string.equals("boolean") && n2 != 2 && n2 != 3 && n2 != 5) {
                    this.recoverableError("a boolean value is expected", this.input.getLineNumber() - 1);
                }
            }
        } else if (this.isSymbol('[')) {
            this.input.advance();
            this.compileNewExpression(2);
            if (this.isSymbol(']')) {
                this.input.advance();
            } else {
                this.terminalError("Expected ]");
            }
            this.pushVariable(n, s);
            this.output.add();
            if (this.isSymbol('=')) {
                this.input.advance();
            } else {
                this.terminalError("Expected =");
            }
            this.compileNewExpression(1);
            this.output.pop("temp", (short)0);
            this.output.pop("pointer", (short)1);
            this.output.push("temp", (short)0);
            this.output.pop("that", (short)0);
        } else {
            this.terminalError("Expected [ or =");
        }
        if (this.isSymbol(';')) {
            this.input.advance();
        } else {
            this.recoverableError("Expected ;");
        }
    }

    private short compileExpressionList() throws JackException {
        if (this.isSymbol('(')) {
            this.input.advance();
        } else {
            this.terminalError("Expected (");
        }
        short s = 0;
        if (this.isSymbol(')')) {
            this.input.advance();
        } else {
            boolean bl = true;
            while (bl) {
                this.compileNewExpression(1);
                s = (short)(s + 1);
                if (this.isSymbol(',')) {
                    this.input.advance();
                    continue;
                }
                if (this.isSymbol(')')) {
                    bl = false;
                    this.input.advance();
                    continue;
                }
                this.terminalError("Expected , or ) in expression list");
            }
        }
        return s;
    }

    private int compileNewExpression(int n) throws JackException {
        ++this.expIndex;
        this.setExpType(n);
        this.compileExpression();
        --this.expIndex;
        return this.expTypes[this.expIndex + 1];
    }

    private void compileExpression() throws JackException {
        boolean bl = false;
        this.compileTerm();
        do {
            if (this.input.getTokenType() != 2) continue;
            char c = this.input.getSymbol();
            boolean bl2 = bl = c == '+' || c == '-' || c == '*' || c == '/' || c == '&' || c == '|' || c == '>' || c == '<' || c == '=';
            if (!bl) continue;
            this.input.advance();
            this.compileTerm();
            switch (c) {
                case '+': {
                    this.output.add();
                    break;
                }
                case '-': {
                    this.output.substract();
                    break;
                }
                case '*': {
                    this.output.callFunction("Math.multiply", (short)2);
                    break;
                }
                case '/': {
                    this.output.callFunction("Math.divide", (short)2);
                    break;
                }
                case '&': {
                    this.output.and();
                    break;
                }
                case '|': {
                    this.output.or();
                    break;
                }
                case '>': {
                    this.output.greaterThan();
                    break;
                }
                case '<': {
                    this.output.lessThan();
                    break;
                }
                case '=': {
                    this.output.equal();
                }
            }
        } while (bl);
    }

    private void compileTerm() throws JackException {
        switch (this.input.getTokenType()) {
            case 4: {
                this.compileIntConst();
                break;
            }
            case 5: {
                this.compileStringConst();
                break;
            }
            case 1: {
                this.compileKeywordConst();
                break;
            }
            case 3: {
                this.compileIdentifierTerm();
                break;
            }
            default: {
                if (this.isSymbol('-')) {
                    this.input.advance();
                    this.compileTerm();
                    this.output.negate();
                    break;
                }
                if (this.isSymbol('~')) {
                    this.input.advance();
                    this.compileTerm();
                    this.output.not();
                    break;
                }
                if (this.isSymbol('(')) {
                    this.input.advance();
                    this.compileNewExpression(1);
                    if (this.isSymbol(')')) {
                        this.input.advance();
                        break;
                    }
                    this.terminalError("Expected )");
                    break;
                }
                this.terminalError("Expected - or ~ or ( in term");
            }
        }
    }

    private void compileIntConst() throws JackException {
        if (this.input.getIntValue() > Short.MAX_VALUE) {
            this.recoverableError("Integer constant too big");
        }
        short s = (short)this.input.getIntValue();
        this.output.push("constant", s);
        if (this.getExpType() < 2) {
            this.setExpType(2);
        } else if (this.getExpType() > 4) {
            this.recoverableError("a numeric value is illegal here");
        }
        this.input.advance();
    }

    private void compileStringConst() throws JackException {
        if (this.getExpType() == 1) {
            this.setExpType(6);
        } else {
            this.recoverableError("A string constant is illegal here");
        }
        String string = this.input.getStringValue();
        short s = (short)string.length();
        this.output.push("constant", s);
        this.output.callFunction("String.new", (short)1);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.output.push("constant", (short)string.charAt(s2));
            this.output.callFunction("String.appendChar", (short)2);
        }
        this.input.advance();
    }

    private void compileKeywordConst() throws JackException {
        int n = this.input.getKeywordType();
        switch (n) {
            case 18: {
                this.output.push("constant", (short)0);
                this.output.not();
                break;
            }
            case 19: 
            case 20: {
                this.output.push("constant", (short)0);
                break;
            }
            case 21: {
                if (this.subroutineType == 2) {
                    this.recoverableError("'this' can't be referenced in a function");
                }
                this.output.push("pointer", (short)0);
                break;
            }
            default: {
                this.terminalError("Illegal keyword in term");
            }
        }
        switch (n) {
            case 18: 
            case 19: {
                if (this.getExpType() <= 2) {
                    this.setExpType(5);
                    break;
                }
                this.recoverableError("A boolean value is illegal here");
                break;
            }
            case 20: {
                if (this.getExpType() == 1) {
                    this.setExpType(8);
                    break;
                }
                this.recoverableError("'null' is illegal here");
                break;
            }
            case 21: {
                if (this.getExpType() == 1) {
                    this.setExpType(7);
                    break;
                }
                this.recoverableError("'this' is illegal here");
            }
        }
        this.input.advance();
    }

    private void compileIdentifierTerm() throws JackException {
        if (this.getExpType() == 6) {
            this.recoverableError("Illegal casting into String constant");
        }
        String string = this.input.getIdentifier();
        int n = this.input.getLineNumber();
        this.input.advance();
        if (this.isSymbol('[')) {
            this.input.advance();
            this.compileNewExpression(2);
            try {
                this.pushVariable(this.identifiers.getKindOf(string), this.identifiers.getIndexOf(string));
            }
            catch (JackException jackException) {
                this.recoverableError(string + " is not defined as a field, parameter or local or static variable", n);
            }
            this.output.add();
            this.output.pop("pointer", (short)1);
            this.output.push("that", (short)0);
            if (this.isSymbol(']')) {
                this.input.advance();
            } else {
                this.terminalError("Expected ]");
            }
        } else if (this.isSymbol('(')) {
            this.compileInternalSubroutineCall(string, n);
        } else if (this.isSymbol('.')) {
            this.compileExternalSubroutineCall(string);
        } else {
            try {
                int n2 = this.identifiers.getKindOf(string);
                short s = this.identifiers.getIndexOf(string);
                if (this.subroutineType == 2 && n2 == 1) {
                    this.recoverableError("A field may not be referenced in a function", n);
                }
                this.pushVariable(n2, s);
                String string2 = this.identifiers.getTypeOf(string);
                if (string2.equals("int")) {
                    if (this.getExpType() <= 2) {
                        this.setExpType(3);
                    } else if (this.getExpType() > 3) {
                        this.recoverableError("An int value is illegal here", n);
                    }
                } else if (string2.equals("char")) {
                    if (this.getExpType() <= 2) {
                        this.setExpType(4);
                    } else if (this.getExpType() > 4 || this.getExpType() == 3) {
                        this.recoverableError("A char value is illegal here", n);
                    }
                } else if (string2.equals("boolean")) {
                    if (this.getExpType() <= 2) {
                        this.setExpType(5);
                    } else if (this.getExpType() != 5) {
                        this.recoverableError("A boolean value is illegal here", n);
                    }
                }
            }
            catch (JackException jackException) {
                this.recoverableError(string + " is not defined as a field, parameter or local or static variable", n);
            }
        }
    }

    private int getExpType() {
        return this.expTypes[this.expIndex];
    }

    private int setExpType(int n) {
        this.expTypes[this.expIndex] = n;
        return this.expTypes[this.expIndex];
    }

    private String getType() throws JackException {
        String string = null;
        if (this.input.getTokenType() == 1) {
            switch (this.input.getKeywordType()) {
                case 5: {
                    string = "int";
                    break;
                }
                case 6: {
                    string = "boolean";
                    break;
                }
                case 7: {
                    string = "char";
                    break;
                }
                default: {
                    this.terminalError("Expected primitive type or class name");
                    break;
                }
            }
        } else if (this.isIdentifier()) {
            string = this.input.getIdentifier();
        } else {
            this.terminalError("Expected primitive type or class name");
        }
        return string;
    }

    private void pushVariable(int n, short s) throws JackException {
        switch (n) {
            case 2: {
                this.output.push("argument", s);
                break;
            }
            case 3: {
                this.output.push("local", s);
                break;
            }
            case 1: {
                this.output.push("this", s);
                break;
            }
            case 0: {
                this.output.push("static", s);
                break;
            }
            default: {
                this.terminalError("Internal Error: Illegal kind");
            }
        }
    }

    private void popVariable(int n, short s) throws JackException {
        switch (n) {
            case 3: {
                this.output.pop("local", s);
                break;
            }
            case 2: {
                this.output.pop("argument", s);
                break;
            }
            case 1: {
                this.output.pop("this", s);
                break;
            }
            case 0: {
                this.output.pop("static", s);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordClass() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordStatic() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 10) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordField() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 11) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordLocal() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 9) return false;
        return true;
    }

    private boolean isIdentifier() {
        return this.input.getTokenType() == 3;
    }

    private boolean isSymbol(char c) {
        return this.input.getTokenType() == 2 && this.input.getSymbol() == c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordMethod() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordFunction() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordConstructor() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordVoid() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 8) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordDo() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 13) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordLet() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 12) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordWhile() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 16) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordReturn() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 17) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordIf() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 14) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordElse() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 15) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKeywordThis() {
        if (this.input.getTokenType() != 1) return false;
        if (this.input.getKeywordType() != 21) return false;
        return true;
    }

    private void terminalError(String string) throws JackException {
        this.terminalError(string, -1, null, null);
    }

    private void terminalError(String string, int n) throws JackException {
        this.terminalError(string, n, null, null);
    }

    private void terminalError(String string, int n, String string2, String string3) throws JackException {
        this.recoverableError(string, n, string2, string3);
        throw new JackException(this.generateMessage(string, n, string2, string3));
    }

    private void warning(String string) {
        this.warning(string, -1, null, null);
    }

    private void warning(String string, int n) {
        this.warning(string, n, null, null);
    }

    private void warning(String string, int n, String string2, String string3) {
        System.err.println(this.generateMessage("Warning: " + string, n, string2, string3));
    }

    private void recoverableError(String string) {
        this.recoverableError(string, -1, null, null);
    }

    private void recoverableError(String string, int n) {
        this.recoverableError(string, n, null, null);
    }

    private void recoverableError(String string, int n, String string2, String string3) {
        System.err.println(this.generateMessage(string, n, string2, string3));
        this.validJack = false;
    }

    private String generateMessage(String string, int n, String string2, String string3) {
        if (string3 == null) {
            string3 = this.fileName;
        }
        if (string2 == null) {
            string2 = this.identifiers.getSubroutineName();
        }
        if (n == -1) {
            n = this.input.getLineNumber();
        }
        return "In " + string3 + " (line " + n + "): " + ("".equals(string2) ? "" : "In subroutine" + (string2 == null ? "" : " " + string2) + ": ") + string;
    }
}

