/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import HackGUI.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitledComboBox
extends JPanel {
    private static final int TOTAL_HEIGHT = 37;
    private static final int COMBO_HEIGHT = 22;
    private JComboBox combo;
    private JLabel title;
    private LinkedList listeners;

    public TitledComboBox(String string, String string2, String[] stringArray, int n) {
        this.title = new JLabel(string);
        this.combo = new JComboBox<String>(stringArray);
        this.combo.setToolTipText(string2);
        Dimension dimension = new Dimension(n, 37);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "North");
        this.add((Component)this.combo, "South");
        this.combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TitledComboBox.this.notifyListeners(actionEvent);
            }
        });
        this.title.setFont(Utilities.thinLabelsFont);
        this.combo.setFont(Utilities.thinLabelsFont);
        this.combo.setPreferredSize(new Dimension(n, 22));
        this.listeners = new LinkedList();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    private void notifyListeners(ActionEvent actionEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public boolean isSelectedIndex(int n) {
        return this.combo.getSelectedIndex() == n;
    }

    public boolean isSelectedItem(String string) {
        return this.combo.getSelectedItem().equals(string);
    }

    public int getSelectedIndex() {
        return this.combo.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.combo.setSelectedIndex(n);
    }

    public void setEnabled(boolean bl) {
        this.combo.setEnabled(bl);
        this.title.setEnabled(bl);
    }
}

