/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.TextFileEvent;
import Hack.ComputerParts.TextFileEventListener;
import Hack.ComputerParts.TextFileGUI;
import HackGUI.Utilities;
import HackGUI.WideTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class TextFileComponent
extends JPanel
implements TextFileGUI {
    private Vector listeners;
    private Vector rowsVector;
    private TextFileTableModel model = new TextFileTableModel();
    private JTable textFileTable;
    private JScrollPane scrollPane;
    private JLabel nameLbl = new JLabel();
    private Set highlightedLines;
    private Set emphasizedLines;
    private boolean isEnabled;

    public TextFileComponent() {
        this.listeners = new Vector();
        this.rowsVector = new Vector();
        this.textFileTable = new WideTable((TableModel)this.model, 1000);
        this.textFileTable.setDefaultRenderer(this.textFileTable.getColumnClass(0), this.getCellRenderer());
        this.textFileTable.setTableHeader(null);
        this.highlightedLines = new HashSet();
        this.emphasizedLines = new HashSet();
        this.enableUserInput();
        this.jbInit();
    }

    public void enableUserInput() {
        this.textFileTable.setRowSelectionAllowed(true);
        this.isEnabled = true;
    }

    public void disableUserInput() {
        this.textFileTable.setRowSelectionAllowed(false);
        this.isEnabled = false;
    }

    public void hideSelect() {
        this.textFileTable.clearSelection();
    }

    public void select(int n, int n2) {
        this.textFileTable.setRowSelectionInterval(n, n2);
        Utilities.tableCenterScroll(this, this.textFileTable, n);
    }

    public void setName(String string) {
        this.nameLbl.setText(string);
    }

    public void addHighlight(int n, boolean bl) {
        if (bl) {
            this.highlightedLines.clear();
        }
        this.highlightedLines.add(new Integer(n));
        Utilities.tableCenterScroll(this, this.textFileTable, n);
        this.repaint();
    }

    public void clearHighlights() {
        this.highlightedLines.clear();
        this.repaint();
    }

    public void addEmphasis(int n) {
        this.emphasizedLines.add(new Integer(n));
        this.repaint();
    }

    public void removeEmphasis(int n) {
        this.emphasizedLines.remove(new Integer(n));
        this.repaint();
    }

    public String getLineAt(int n) {
        return (String)this.rowsVector.elementAt(n);
    }

    public int getNumberOfLines() {
        return this.rowsVector.size();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new TextFileCellRenderer();
    }

    public void addTextFileListener(TextFileEventListener textFileEventListener) {
        this.listeners.addElement(textFileEventListener);
    }

    public void removeTextFileListener(TextFileEventListener textFileEventListener) {
        this.listeners.removeElement(textFileEventListener);
    }

    public void notifyTextFileListeners(String string, int n) {
        TextFileEvent textFileEvent = new TextFileEvent((Object)this, string, n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TextFileEventListener)this.listeners.elementAt(i)).rowSelected(textFileEvent);
        }
    }

    public void addLine(String string) {
        this.rowsVector.addElement(string);
        this.textFileTable.revalidate();
        this.repaint();
        this.addHighlight(this.rowsVector.size() - 1, false);
    }

    public void setLineAt(int n, String string) {
        this.rowsVector.setElementAt(string, n);
        this.addHighlight(n, false);
    }

    public void setContents(String[] stringArray) {
        this.rowsVector.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.rowsVector.addElement(stringArray[i]);
        }
        this.textFileTable.revalidate();
        this.repaint();
    }

    public void setContents(String string) {
        this.rowsVector.removeAllElements();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.rowsVector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.textFileTable.clearSelection();
        this.textFileTable.revalidate();
        this.repaint();
    }

    public void reset() {
        this.highlightedLines.clear();
        this.rowsVector.removeAllElements();
        this.textFileTable.revalidate();
        this.textFileTable.clearSelection();
        this.repaint();
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.textFileTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
        this.textFileTable.getParent().setSize(new Dimension(1000, n2));
    }

    public int getTableWidth() {
        return 241;
    }

    private void jbInit() {
        this.textFileTable.setShowHorizontalLines(false);
        ListSelectionModel listSelectionModel = this.textFileTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!TextFileComponent.this.isEnabled || listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    TextFileComponent.this.notifyTextFileListeners((String)TextFileComponent.this.rowsVector.elementAt(n), n);
                }
            }
        });
        this.setLayout(null);
        this.scrollPane = new JScrollPane(this.textFileTable);
        this.scrollPane.setLocation(0, 27);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(this.scrollPane.getHorizontalScrollBar().getBlockIncrement());
        this.nameLbl.setBounds(new Rectangle(3, 3, 102, 21));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.textFileTable.setFont(Utilities.valueFont);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.nameLbl, null);
    }

    public class TextFileCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(null);
            this.setBackground(null);
            this.setRenderer(n, n2);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        public void setRenderer(int n, int n2) {
            if (TextFileComponent.this.highlightedLines.contains(new Integer(n))) {
                this.setBackground(Color.yellow);
            } else {
                this.setBackground(null);
            }
            if (TextFileComponent.this.emphasizedLines.contains(new Integer(n))) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(null);
            }
        }
    }

    class TextFileTableModel
    extends AbstractTableModel {
        TextFileTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return TextFileComponent.this.rowsVector.size();
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            return TextFileComponent.this.rowsVector.elementAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

