/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import HackGUI.Utilities;
import HackGUI.WideTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class FileDisplayComponent
extends JPanel {
    private String[] rows = new String[0];
    private WideTable fileDisplayTable;
    private JScrollPane scrollPane;
    private int selectedRow = -1;
    private String fileName;

    public FileDisplayComponent() {
        this.jbInit();
    }

    public void setSelectedRow(int n) {
        this.selectedRow = n;
        if (this.selectedRow >= 0) {
            Utilities.tableCenterScroll(this, this.fileDisplayTable, this.selectedRow);
        }
        this.repaint();
    }

    public void deleteContent() {
        this.rows = new String[0];
        this.fileDisplayTable.revalidate();
        this.repaint();
    }

    public void refresh() {
        this.setContents(this.fileName);
    }

    public synchronized void setContents(String string) {
        this.fileName = string;
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.rows = new String[vector.size()];
        vector.toArray(this.rows);
        this.fileDisplayTable.clearSelection();
        this.fileDisplayTable.revalidate();
        try {
            this.wait(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
    }

    public void updateSize(int n, int n2) {
        this.setSize(n, n2);
        this.scrollPane.setPreferredSize(new Dimension(n, n2));
        this.scrollPane.setSize(n, n2);
    }

    private void jbInit() {
        this.setLayout(null);
        this.fileDisplayTable = new WideTable((TableModel)new FileDisplayTableModel(), 1000);
        this.fileDisplayTable.setTableHeader(null);
        this.fileDisplayTable.setDefaultRenderer(this.fileDisplayTable.getColumnClass(0), new FileDisplayTableCellRenderer());
        this.scrollPane = new JScrollPane(this.fileDisplayTable);
        this.fileDisplayTable.setRowSelectionAllowed(false);
        this.fileDisplayTable.setShowHorizontalLines(false);
        this.fileDisplayTable.setShowVerticalLines(false);
        this.fileDisplayTable.setFont(Utilities.valueFont);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(this.scrollPane.getHorizontalScrollBar().getBlockIncrement());
        this.scrollPane.setLocation(0, 0);
        this.scrollPane.setPreferredSize(new Dimension(516, 260));
        this.scrollPane.setSize(516, 260);
        this.setSize(516, 260);
        this.add((Component)this.scrollPane, null);
    }

    class FileDisplayTableCellRenderer
    extends DefaultTableCellRenderer {
        FileDisplayTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(null);
            this.setBackground(null);
            this.setRenderer(n, n2);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        public void setRenderer(int n, int n2) {
            if (n == FileDisplayComponent.this.selectedRow) {
                this.setBackground(Color.yellow);
            } else {
                this.setBackground(null);
            }
        }
    }

    class FileDisplayTableModel
    extends AbstractTableModel {
        FileDisplayTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return FileDisplayComponent.this.rows.length;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            return FileDisplayComponent.this.rows[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

