/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import HackGUI.EnterPressedListener;
import HackGUI.FilesTypeEvent;
import HackGUI.FilesTypeListener;
import HackGUI.ViewableFileChooserComponent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooserWindow
extends JFrame
implements EnterPressedListener {
    private ViewableFileChooserComponent fileChooser;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private ImageIcon okIcon = new ImageIcon("bin/images/ok.gif");
    private ImageIcon cancelIcon = new ImageIcon("bin/images/cancel.gif");
    private Vector listeners = new Vector();

    public FileChooserWindow(FileFilter fileFilter) {
        this.fileChooser = new ViewableFileChooserComponent();
        this.fileChooser.setFilter(fileFilter);
        this.jbInit();
    }

    public void showWindow() {
        this.setVisible(true);
        this.fileChooser.getTextField().requestFocus();
    }

    public void enterPressed() {
        String string = null;
        string = this.fileChooser.getFileName();
        this.fileChooser.setCurrentFileName(string);
        if (string != null) {
            this.notifyListeners(string);
        }
        this.setVisible(false);
    }

    public void setFileName(String string) {
        this.fileChooser.setCurrentFileName(string);
        this.fileChooser.showCurrentFileName();
    }

    public void setName(String string) {
        this.fileChooser.setName(string);
    }

    public JTextField getTextField() {
        return this.fileChooser.getTextField();
    }

    private void jbInit() {
        this.fileChooser.addListener(this);
        this.fileChooser.setWindowLocation(647, 3);
        this.getContentPane().setLayout(null);
        this.setTitle("Files selection");
        this.fileChooser.setBounds(new Rectangle(5, 2, 482, 48));
        this.okButton.setToolTipText("OK");
        this.okButton.setIcon(this.okIcon);
        this.okButton.setBounds(new Rectangle(124, 64, 63, 44));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserWindow.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setBounds(new Rectangle(282, 63, 63, 44));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserWindow.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setToolTipText("CANCEL");
        this.cancelButton.setIcon(this.cancelIcon);
        this.getContentPane().add((Component)this.fileChooser, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.okButton, null);
        this.setSize(496, 150);
        this.setLocation(145, 250);
    }

    public void addListener(FilesTypeListener filesTypeListener) {
        this.listeners.addElement(filesTypeListener);
    }

    public void removeListener(FilesTypeListener filesTypeListener) {
        this.listeners.removeElement(filesTypeListener);
    }

    public void notifyListeners(String string) {
        FilesTypeEvent filesTypeEvent = new FilesTypeEvent(this, string, null, null);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FilesTypeListener)this.listeners.elementAt(i)).filesNamesChanged(filesTypeEvent);
        }
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.fileChooser.showCurrentFileName();
        this.setVisible(false);
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.fileChooser.getFileName();
        this.fileChooser.setCurrentFileName(string);
        this.setVisible(false);
        if (string != null) {
            this.notifyListeners(string);
        }
    }
}

