/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import HackGUI.FileChooserComponent;
import HackGUI.FilesTypeEvent;
import HackGUI.FilesTypeListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ControllerFileChooser
extends JFrame {
    private FileChooserComponent outputFileChooser = new FileChooserComponent();
    private FileChooserComponent comparisonFileChooser = new FileChooserComponent();
    private FileChooserComponent scriptFileChooser = new FileChooserComponent();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private ImageIcon okIcon = new ImageIcon("bin/images/ok.gif");
    private ImageIcon cancelIcon = new ImageIcon("bin/images/cancel.gif");
    private Vector listeners = new Vector();

    public ControllerFileChooser() {
        this.jbInit();
        this.scriptFileChooser.setName("Script File :");
        this.outputFileChooser.setName("Output File :");
        this.comparisonFileChooser.setName("Comparison File :");
    }

    public void showWindow() {
        this.setVisible(true);
        this.scriptFileChooser.getTextField().requestFocus();
    }

    public void addListener(FilesTypeListener filesTypeListener) {
        this.listeners.addElement(filesTypeListener);
    }

    public void removeListener(FilesTypeListener filesTypeListener) {
        this.listeners.removeElement(filesTypeListener);
    }

    public void notifyListeners(String string, String string2, String string3) {
        FilesTypeEvent filesTypeEvent = new FilesTypeEvent(this, string, string2, string3);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FilesTypeListener)this.listeners.elementAt(i)).filesNamesChanged(filesTypeEvent);
        }
    }

    public void setScriptDir(String string) {
        this.scriptFileChooser.setScriptDir(string);
    }

    public void setScriptFile(String string) {
        this.scriptFileChooser.setCurrentFileName(string);
        this.scriptFileChooser.showCurrentFileName();
    }

    public void setOutputFile(String string) {
        this.outputFileChooser.setCurrentFileName(string);
        this.outputFileChooser.showCurrentFileName();
    }

    public void setComparisonFile(String string) {
        this.comparisonFileChooser.setCurrentFileName(string);
        this.comparisonFileChooser.showCurrentFileName();
    }

    private void jbInit() {
        this.getContentPane().setLayout(null);
        this.setTitle("Files selection");
        this.scriptFileChooser.setBounds(new Rectangle(5, 2, 485, 48));
        this.outputFileChooser.setBounds(new Rectangle(5, 38, 485, 48));
        this.comparisonFileChooser.setBounds(new Rectangle(5, 74, 485, 48));
        this.okButton.setToolTipText("OK");
        this.okButton.setIcon(this.okIcon);
        this.okButton.setBounds(new Rectangle(123, 134, 63, 44));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerFileChooser.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setBounds(new Rectangle(283, 134, 63, 44));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerFileChooser.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setToolTipText("CANCEL");
        this.cancelButton.setIcon(this.cancelIcon);
        this.getContentPane().add((Component)this.scriptFileChooser, null);
        this.getContentPane().add((Component)this.outputFileChooser, null);
        this.getContentPane().add((Component)this.comparisonFileChooser, null);
        this.getContentPane().add((Component)this.okButton, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.setSize(500, 210);
        this.setLocation(20, 415);
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.scriptFileChooser.showCurrentFileName();
        this.outputFileChooser.showCurrentFileName();
        this.comparisonFileChooser.showCurrentFileName();
        this.setVisible(false);
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.scriptFileChooser.isFileNameChanged() || !this.scriptFileChooser.getFileName().equals("")) {
            string = this.scriptFileChooser.getFileName();
            this.scriptFileChooser.setCurrentFileName(string);
            this.scriptFileChooser.showCurrentFileName();
        }
        if (this.outputFileChooser.isFileNameChanged() || !this.outputFileChooser.getFileName().equals("")) {
            string2 = this.outputFileChooser.getFileName();
            this.outputFileChooser.setCurrentFileName(string2);
            this.outputFileChooser.showCurrentFileName();
        }
        if (this.comparisonFileChooser.isFileNameChanged() || !this.comparisonFileChooser.getFileName().equals("")) {
            string3 = this.comparisonFileChooser.getFileName();
            this.comparisonFileChooser.setCurrentFileName(string3);
            this.comparisonFileChooser.showCurrentFileName();
        }
        if (string != null || string2 != null || string3 != null) {
            this.notifyListeners(string, string2, string3);
        }
        this.setVisible(false);
    }
}

