/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.BusGUI;
import Hack.Controller.HackController;
import HackGUI.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;

public class BusComponent
extends JPanel
implements ActionListener,
BusGUI {
    private static final int MIN_MS = 10;
    private static final int MAX_MS = 40;
    private static final double MIN_STEP_LENGTH = 3.0;
    private static final double MAX_STEP_LENGTH = 11.0;
    private static final int HEIGHT = 22;
    private static final int WIDTH = 128;
    protected JTextField txtField = new JTextField();
    private Timer timer = new Timer(1000, this);
    protected Border txtBorder;
    private int[] delays;
    private double[] stepLengths;
    private int counter = 0;
    private double dx = 0.0;
    private double dy = 0.0;
    private double x = 0.0;
    private double y = 0.0;
    private double currentStepLength;

    public BusComponent() {
        int n = 5;
        float[] fArray = HackController.SPEED_FUNCTION;
        this.stepLengths = new double[n];
        this.delays = new int[n];
        for (int i = 0; i < n; ++i) {
            this.stepLengths[i] = (double)fArray[i] * 8.0 + 3.0;
            this.delays[i] = (int)(40.0 - (double)fArray[i] * 30.0);
        }
        this.setSpeed(3);
        this.jbInit();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.x += this.dx;
        this.y += this.dy;
        this.txtField.setLocation((int)this.x, (int)this.y);
        --this.counter;
        if (this.counter == 0) {
            this.timer.stop();
            this.txtField.setVisible(false);
            this.notify();
        }
    }

    public synchronized void move(Point point, Point point2, String string) {
        this.txtField.setText(string);
        this.x = point.getX() - 2.0;
        this.y = point.getY() - 2.0;
        this.txtField.setLocation((int)this.x, (int)this.y);
        this.txtField.setVisible(true);
        int n = (int)(point2.getX() - point.getX()) + 2;
        int n2 = (int)(point2.getY() - point.getY()) + 2;
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        this.dy = this.currentStepLength * (double)n4 / (double)(n3 + n4);
        this.dx = this.currentStepLength - this.dy;
        this.counter = (int)((double)n3 / this.dx);
        if (n < 0) {
            this.dx = -this.dx;
        }
        if (n2 < 0) {
            this.dy = -this.dy;
        }
        this.timer.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setSpeed(int n) {
        this.timer.setDelay(this.delays[n - 1]);
        this.currentStepLength = this.stepLengths[n - 1];
    }

    public void reset() {
    }

    public void setBusFont(Font font) {
        this.txtField.setFont(font);
    }

    public void setBusSize(Rectangle rectangle) {
        this.txtField.setBounds(rectangle);
    }

    private void jbInit() {
        this.txtBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, Color.orange);
        this.txtField.setBounds(new Rectangle(10, 8, 128, 22));
        this.txtField.setBackground(Color.white);
        this.txtField.setEnabled(false);
        this.txtField.setBorder(this.txtBorder);
        this.txtField.setDisabledTextColor(Color.black);
        this.txtField.setEditable(false);
        this.txtField.setHorizontalAlignment(4);
        this.txtField.setFont(Utilities.valueFont);
        this.setLayout(null);
        this.add((Component)this.txtField, null);
        this.txtField.setVisible(false);
        this.setOpaque(false);
    }
}

