/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.Controller.Breakpoint;
import HackGUI.BreakpointChangedEvent;
import HackGUI.BreakpointChangedListener;
import HackGUI.BreakpointVariablesWindow;
import HackGUI.BreakpointsChangedEvent;
import HackGUI.BreakpointsChangedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class BreakpointWindow
extends JFrame
implements MouseListener,
BreakpointChangedListener {
    private JTable breakpointTable;
    private Vector breakpoints;
    private BreakpointTableModel model;
    private Vector listeners;
    private FlowLayout flowLayout = new FlowLayout();
    private JButton addButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton okButton = new JButton();
    private ColoredTableCellRenderer coloredRenderer = new ColoredTableCellRenderer();
    private ImageIcon addIcon = new ImageIcon("bin/images/smallplus.gif");
    private ImageIcon removeIcon = new ImageIcon("bin/images/smallminus.gif");
    private ImageIcon okIcon = new ImageIcon("bin/images/ok2.gif");
    private BreakpointVariablesWindow variables = new BreakpointVariablesWindow();
    private int selectedRowIndex = -1;

    public BreakpointWindow() {
        super("Breakpoint Panel");
        this.breakpoints = new Vector();
        this.model = new BreakpointTableModel();
        this.breakpointTable = new JTable(this.model);
        this.breakpointTable.setDefaultRenderer(this.breakpointTable.getColumnClass(0), this.coloredRenderer);
        this.listeners = new Vector();
        this.setResizable(false);
        this.jbInit();
    }

    public void setBreakpoints(Vector vector) {
        this.breakpoints = (Vector)vector.clone();
        this.breakpointTable.revalidate();
    }

    public void setVariables(String[] stringArray) {
        this.variables.setVariables(stringArray);
    }

    public void addBreakpointListener(BreakpointsChangedListener breakpointsChangedListener) {
        this.listeners.addElement(breakpointsChangedListener);
    }

    public void removeBreakpointListener(BreakpointsChangedListener breakpointsChangedListener) {
        this.listeners.removeElement(breakpointsChangedListener);
    }

    public void notifyListeners() {
        BreakpointsChangedEvent breakpointsChangedEvent = new BreakpointsChangedEvent(this, this.breakpoints);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((BreakpointsChangedListener)this.listeners.elementAt(i)).breakpointsChanged(breakpointsChangedEvent);
        }
    }

    public JTable getTable() {
        return this.breakpointTable;
    }

    public void breakpointChanged(BreakpointChangedEvent breakpointChangedEvent) {
        Breakpoint breakpoint = breakpointChangedEvent.getBreakpoint();
        if (this.selectedRowIndex == -1) {
            this.breakpoints.addElement(breakpoint);
        } else {
            this.breakpoints.setElementAt(breakpoint, this.selectedRowIndex);
        }
        this.breakpointTable.revalidate();
        this.repaint();
        this.notifyListeners();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n;
            this.selectedRowIndex = n = this.breakpointTable.getSelectedRow();
            this.variables.setBreakpointName(((Breakpoint)this.breakpoints.elementAt(n)).getVarName());
            this.variables.setBreakpointValue(((Breakpoint)this.breakpoints.elementAt(n)).getValue());
            this.variables.showWindow();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    private void jbInit() {
        this.variables.addListener(this);
        this.getContentPane().setLayout(this.flowLayout);
        this.breakpointTable.setSelectionMode(0);
        this.breakpointTable.addMouseListener(this);
        ListSelectionModel listSelectionModel = this.breakpointTable.getSelectionModel();
        JScrollPane jScrollPane = new JScrollPane(this.breakpointTable);
        jScrollPane.setPreferredSize(new Dimension(190, 330));
        this.addButton.setPreferredSize(new Dimension(35, 25));
        this.addButton.setToolTipText("Add breakpoint");
        this.addButton.setIcon(this.addIcon);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointWindow.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.removeButton.setPreferredSize(new Dimension(35, 25));
        this.removeButton.setToolTipText("Remove breakpoint");
        this.removeButton.setIcon(this.removeIcon);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointWindow.this.removeButton_actionPerformed(actionEvent);
            }
        });
        this.okButton.setPreferredSize(new Dimension(35, 25));
        this.okButton.setToolTipText("OK");
        this.okButton.setIcon(this.okIcon);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointWindow.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)jScrollPane, null);
        this.getContentPane().add((Component)this.addButton, null);
        this.getContentPane().add((Component)this.removeButton, null);
        this.getContentPane().add((Component)this.okButton, null);
        this.setSize(210, 410);
        this.setLocation(250, 250);
    }

    public void addButton_actionPerformed(ActionEvent actionEvent) {
        this.breakpointTable.clearSelection();
        this.selectedRowIndex = -1;
        this.variables.setNameCombo(0);
        this.variables.setBreakpointName("");
        this.variables.setBreakpointValue("");
        this.variables.showWindow();
    }

    public void removeButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.breakpointTable.getSelectedRow();
        if (n >= 0 && n < this.breakpointTable.getRowCount()) {
            this.model.removeRow(this.breakpointTable.getSelectedRow());
            this.breakpointTable.revalidate();
            this.notifyListeners();
        }
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        ColoredTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (((Breakpoint)BreakpointWindow.this.breakpoints.elementAt(n)).isReached()) {
                this.setBackground(Color.red);
            } else {
                this.setBackground(null);
            }
            this.setHorizontalAlignment(0);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    class BreakpointTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Variable Name", "Value"};

        BreakpointTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return BreakpointWindow.this.breakpoints.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            Breakpoint breakpoint = (Breakpoint)BreakpointWindow.this.breakpoints.elementAt(n);
            if (n2 == 0) {
                return breakpoint.getVarName();
            }
            return breakpoint.getValue();
        }

        public void removeRow(int n) {
            if (BreakpointWindow.this.breakpoints.size() > 0) {
                BreakpointWindow.this.breakpoints.removeElementAt(n);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

