/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.CPUEmulator.ScreenGUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ScreenComponent
extends JPanel
implements ScreenGUI,
ActionListener {
    private static final int ANIMATION_CLOCK_INTERVALS = 50;
    private static final int STATIC_CLOCK_INTERVALS = 500;
    private short[] data;
    private boolean redraw = true;
    private int[] x;
    private int[] y;
    protected Timer timer;

    public ScreenComponent() {
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createEtchedBorder());
        Insets insets = this.getBorder().getBorderInsets(this);
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        this.setPreferredSize(new Dimension(512 + n, 256 + n2));
        this.setSize(512 + n, 256 + n2);
        this.data = new short[131072];
        this.x = new int[131072];
        this.y = new int[131072];
        this.x[0] = insets.left;
        this.y[0] = insets.top;
        for (int i = 1; i < 131072; ++i) {
            this.x[i] = this.x[i - 1] + 16;
            this.y[i] = this.y[i - 1];
            if (this.x[i] != 512 + insets.left) continue;
            this.x[i] = insets.left;
            int n3 = i;
            this.y[n3] = this.y[n3] + 1;
        }
        this.timer = new Timer(500, this);
        this.timer.start();
    }

    public void setValueAt(int n, short s) {
        this.data[n] = s;
        this.redraw = true;
    }

    public void setContents(short[] sArray) {
        this.data = sArray;
        this.redraw = true;
    }

    public void reset() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.redraw = true;
    }

    public void refresh() {
        if (this.redraw) {
            this.repaint();
            this.redraw = false;
        }
    }

    public void startAnimation() {
        this.timer.setDelay(50);
    }

    public void stopAnimation() {
        this.timer.setDelay(500);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.redraw) {
            this.repaint();
            this.redraw = false;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (int i = 0; i < 131072; ++i) {
            if (this.data[i] == 0) continue;
            if (this.data[i] == 65535) {
                graphics.drawLine(this.x[i], this.y[i], this.x[i] + 15, this.y[i]);
                continue;
            }
            short s = this.data[i];
            for (int j = 0; j < 16; ++j) {
                if ((s & 1) == 1) {
                    graphics.drawLine(this.x[i] + j, this.y[i], this.x[i] + j, this.y[i]);
                }
                s = (short)(s >> 1);
            }
        }
    }
}

