/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.HardwareSimulator.HardwareSimulator;
import Hack.HardwareSimulator.PartPinInfo;
import Hack.HardwareSimulator.PartPinsGUI;
import HackGUI.Format;
import HackGUI.Utilities;
import SimulatorsGUI.PinValueEvent;
import SimulatorsGUI.PinsComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PartPinsComponent
extends PinsComponent
implements PartPinsGUI {
    private PartPinInfo[] partPins;
    private String[] valuesStr;
    private PartPinsTableCellRenderer renderer = new PartPinsTableCellRenderer();
    private boolean isEnabled = true;
    private JLabel partNameLbl = new JLabel();

    public PartPinsComponent() {
        this.partPins = new PartPinInfo[0];
        this.valuesStr = new String[0];
        this.pinsTable.setDefaultRenderer(this.pinsTable.getColumnClass(0), this.renderer);
        this.jbInit();
    }

    public void setPartName(String string) {
        this.partNameLbl.setText(string);
    }

    public void enableUserInput() {
        this.isEnabled = true;
    }

    public void disableUserInput() {
        this.isEnabled = false;
    }

    protected int getValueColumn() {
        return 2;
    }

    protected TableModel getTableModel() {
        return new PartPinsTableModel();
    }

    public void pinValueChanged(PinValueEvent pinValueEvent) {
        this.pinsTable.setEnabled(true);
        if (pinValueEvent.getIsOk()) {
            this.valuesStr[this.pinsTable.getSelectedRow()] = pinValueEvent.getValueStr();
            this.partPins[this.pinsTable.getSelectedRow()].value = Format.translateValueToShort((String)pinValueEvent.getValueStr(), (int)this.dataFormat);
        }
        this.notifyListeners(this.pinsTable.getSelectedRow(), Format.translateValueToShort((String)pinValueEvent.getValueStr(), (int)this.dataFormat));
    }

    public Point getCoordinates(int n) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Rectangle rectangle = this.pinsTable.getCellRect(n, 2, true);
        this.pinsTable.scrollRectToVisible(rectangle);
        return new Point((int)(rectangle.getX() + this.topLevelLocation.getX()), (int)(rectangle.getY() + this.topLevelLocation.getY() - (double)jScrollBar.getValue()));
    }

    public void setContents(Vector vector) {
        this.partPins = new PartPinInfo[vector.size()];
        this.valuesStr = new String[vector.size()];
        vector.toArray(this.partPins);
        for (int i = 0; i < this.partPins.length; ++i) {
            this.valuesStr[i] = Format.translateValueToString((short)this.partPins[i].value, (int)this.dataFormat);
        }
        this.pinsTable.clearSelection();
        this.pinsTable.revalidate();
        this.repaint();
    }

    public String getValueAsString(int n) {
        return this.valuesStr[n];
    }

    public void setValueAt(int n, short s) {
        this.partPins[n].value = s;
        this.valuesStr[n] = Format.translateValueToString((short)s, (int)this.dataFormat);
        this.repaint();
    }

    public void reset() {
        this.pinsTable.clearSelection();
        this.repaint();
        this.hideFlash();
        this.hideHighlight();
    }

    protected void determineColumnWidth() {
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.pinsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(20);
                continue;
            }
            if (i == 1) {
                tableColumn.setPreferredWidth(20);
                continue;
            }
            if (i != 2) continue;
            tableColumn.setPreferredWidth(180);
        }
    }

    private void jbInit() {
        this.partNameLbl.setFont(Utilities.bigLabelsFont);
        this.partNameLbl.setHorizontalAlignment(0);
        this.partNameLbl.setText("keyboard");
        this.partNameLbl.setForeground(Color.black);
        this.partNameLbl.setBounds(new Rectangle(62, 10, 102, 21));
        this.add((Component)this.partNameLbl, null);
    }

    class PartPinsTableCellRenderer
    extends DefaultTableCellRenderer {
        PartPinsTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (n2 == 0 || n2 == 1) {
                this.setHorizontalAlignment(0);
                this.setForeground(null);
                this.setBackground(null);
            } else {
                this.setHorizontalAlignment(4);
                for (int i = 0; i < PartPinsComponent.this.highlightIndex.size(); ++i) {
                    if (n == (Integer)PartPinsComponent.this.highlightIndex.elementAt(i)) {
                        this.setForeground(Color.blue);
                        break;
                    }
                    this.setForeground(null);
                }
                if (n == PartPinsComponent.this.flashIndex) {
                    this.setBackground(Color.orange);
                } else {
                    this.setBackground(null);
                }
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    class PartPinsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Part pin", "Gate pin", "Value"};

        PartPinsTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            if (PartPinsComponent.this.partPins == null) {
                return 0;
            }
            return PartPinsComponent.this.partPins.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            if (n2 == 0) {
                string = HardwareSimulator.getFullPinName((String)((PartPinsComponent)PartPinsComponent.this).partPins[n].partPinName, (byte[])((PartPinsComponent)PartPinsComponent.this).partPins[n].partPinSubBus);
            } else if (n2 == 1) {
                string = HardwareSimulator.getFullPinName((String)((PartPinsComponent)PartPinsComponent.this).partPins[n].gatePinName, (byte[])((PartPinsComponent)PartPinsComponent.this).partPins[n].gatePinSubBus);
            } else if (n2 == 2) {
                string = PartPinsComponent.this.valuesStr[n];
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = ((String)object).trim();
            try {
                ((PartPinsComponent)PartPinsComponent.this).valuesStr[n] = string;
                ((PartPinsComponent)PartPinsComponent.this).partPins[n].value = Format.translateValueToShort((String)string, (int)PartPinsComponent.this.dataFormat);
                PartPinsComponent.this.notifyListeners((short)n, ((PartPinsComponent)PartPinsComponent.this).partPins[n].value);
            }
            catch (NumberFormatException numberFormatException) {
                PartPinsComponent.this.notifyErrorListeners("Illegal value");
                ((PartPinsComponent)PartPinsComponent.this).valuesStr[n] = Format.translateValueToString((short)((PartPinsComponent)PartPinsComponent.this).partPins[n].value, (int)PartPinsComponent.this.dataFormat);
            }
            PartPinsComponent.this.repaint();
        }
    }
}

