/*
 * Decompiled with CFR 0.152.
 */
package Hack.ComputerParts;

import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.InteractiveValueComputerPart;
import Hack.ComputerParts.Memory;
import Hack.ComputerParts.MemorySegmentGUI;

public class MemorySegment
extends InteractiveValueComputerPart {
    protected MemorySegmentGUI gui;
    protected Memory mainMemory;
    protected int startAddress;

    public MemorySegment(Memory memory, MemorySegmentGUI memorySegmentGUI) {
        super(memorySegmentGUI != null);
        this.init(memory, memorySegmentGUI);
    }

    public MemorySegment(Memory memory, MemorySegmentGUI memorySegmentGUI, short s, short s2) {
        super(memorySegmentGUI != null, s, s2);
        this.init(memory, memorySegmentGUI);
    }

    private void init(Memory memory, MemorySegmentGUI memorySegmentGUI) {
        this.mainMemory = memory;
        this.gui = memorySegmentGUI;
        if (this.hasGUI) {
            memorySegmentGUI.addListener(this);
            memorySegmentGUI.addErrorListener(this);
        }
    }

    public void setStartAddress(int n) {
        this.startAddress = n;
        if (this.displayChanges) {
            this.gui.setStartAddress(n);
        }
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public void doSetValueAt(int n, short s) {
        if (this.mainMemory.getValueAt(this.startAddress + n) != s) {
            this.mainMemory.setValueAt(this.startAddress + n, s, true);
        }
    }

    public short getValueAt(int n) {
        return this.mainMemory.getValueAt(this.startAddress + n);
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public void refreshGUI() {
        super.refreshGUI();
        if (this.displayChanges) {
            this.gui.setStartAddress(this.startAddress);
        }
    }

    public void scrollTo(int n) {
        if (this.displayChanges) {
            this.gui.scrollTo(this.startAddress + n);
        }
    }

    public void hideSelect() {
        if (this.displayChanges) {
            this.gui.hideSelect();
        }
    }
}

