/*
 * Decompiled with CFR 0.152.
 */
package Hack.ComputerParts;

import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.InteractiveValueComputerPart;
import Hack.ComputerParts.MemoryGUI;
import Hack.Events.ClearEvent;
import Hack.Events.ClearEventListener;

public class Memory
extends InteractiveValueComputerPart
implements ClearEventListener {
    protected int size;
    protected short[] mem;
    protected MemoryGUI gui;

    public Memory(int n, MemoryGUI memoryGUI) {
        super(memoryGUI != null);
        this.init(n, memoryGUI);
    }

    public Memory(int n, MemoryGUI memoryGUI, short s, short s2) {
        super(memoryGUI != null, s, s2);
        this.init(n, memoryGUI);
    }

    private void init(int n, MemoryGUI memoryGUI) {
        this.size = n;
        this.gui = memoryGUI;
        this.mem = new short[n];
        if (this.hasGUI) {
            memoryGUI.setContents(this.mem);
            memoryGUI.addListener(this);
            memoryGUI.addClearListener(this);
            memoryGUI.addErrorListener(this);
        }
    }

    public short getValueAt(int n) {
        return this.mem[n];
    }

    public void doSetValueAt(int n, short s) {
        this.mem[n] = s;
    }

    public short[] getContents() {
        return this.mem;
    }

    public void setContents(short[] sArray, int n) {
        System.arraycopy(sArray, 0, this.mem, n, sArray.length);
        this.refreshGUI();
    }

    public int getSize() {
        return this.size;
    }

    public void reset() {
        super.reset();
        for (int i = 0; i < this.size; ++i) {
            this.mem[i] = this.nullValue;
        }
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public void refreshGUI() {
        super.refreshGUI();
        if (this.displayChanges) {
            this.gui.setContents(this.mem);
        }
    }

    public void scrollTo(int n) {
        if (this.displayChanges) {
            this.gui.scrollTo(n);
        }
    }

    public void clearRequested(ClearEvent clearEvent) {
        this.reset();
    }

    public void select(int n, int n2) {
        if (this.displayChanges) {
            this.gui.select(n, n2);
        }
    }

    public void hideSelect() {
        if (this.displayChanges) {
            this.gui.hideSelect();
        }
    }
}

