/*
 * Decompiled with CFR 0.152.
 */
package Hack.ComputerParts;

import Hack.ComputerParts.ComputerPartErrorEvent;
import Hack.ComputerParts.ComputerPartErrorEventListener;
import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.ComputerPartEventListener;
import Hack.ComputerParts.InteractiveValueComputerPartGUI;
import Hack.ComputerParts.ValueComputerPart;
import Hack.Events.ErrorEvent;
import Hack.Events.ErrorEventListener;
import java.util.Vector;

public abstract class InteractiveValueComputerPart
extends ValueComputerPart
implements ComputerPartEventListener,
ErrorEventListener {
    private Vector errorListeners = new Vector();
    private short minValue;
    private short maxValue;
    private int startEnabledRange;
    private int endEnabledRange;
    private boolean grayDisabledRange;

    public InteractiveValueComputerPart(boolean bl) {
        super(bl);
        this.minValue = Short.MIN_VALUE;
        this.maxValue = Short.MAX_VALUE;
        this.startEnabledRange = -1;
        this.endEnabledRange = -1;
    }

    public InteractiveValueComputerPart(boolean bl, short s, short s2) {
        super(bl);
        this.minValue = s;
        this.maxValue = s2;
    }

    public void addErrorListener(ComputerPartErrorEventListener computerPartErrorEventListener) {
        this.errorListeners.addElement(computerPartErrorEventListener);
    }

    public void removeErrorListener(ComputerPartErrorEventListener computerPartErrorEventListener) {
        this.errorListeners.removeElement(computerPartErrorEventListener);
    }

    public void notifyErrorListeners(String string) {
        ComputerPartErrorEvent computerPartErrorEvent = new ComputerPartErrorEvent(this, string);
        for (int i = 0; i < this.errorListeners.size(); ++i) {
            ((ComputerPartErrorEventListener)this.errorListeners.elementAt(i)).computerPartErrorOccured(computerPartErrorEvent);
        }
    }

    public void clearErrorListeners() {
        ComputerPartErrorEvent computerPartErrorEvent = new ComputerPartErrorEvent(this, null);
        for (int i = 0; i < this.errorListeners.size(); ++i) {
            ((ComputerPartErrorEventListener)this.errorListeners.elementAt(i)).computerPartErrorOccured(computerPartErrorEvent);
        }
    }

    public void errorOccured(ErrorEvent errorEvent) {
        this.notifyErrorListeners(errorEvent.getErrorMessage());
    }

    public void valueChanged(ComputerPartEvent computerPartEvent) {
        short s = computerPartEvent.getValue();
        int n = computerPartEvent.getIndex();
        this.clearErrorListeners();
        if ((s < this.minValue || s > this.maxValue) && s != this.nullValue) {
            this.notifyErrorListeners("Value must be in the range " + this.minValue + ".." + this.maxValue);
            this.quietUpdateGUI(n, this.getValueAt(n));
        } else {
            this.setValueAt(n, s, true);
        }
    }

    public void guiGainedFocus() {
    }

    public void enableUserInput() {
        if (this.hasGUI) {
            ((InteractiveValueComputerPartGUI)this.getGUI()).enableUserInput();
        }
    }

    public void disableUserInput() {
        if (this.hasGUI) {
            ((InteractiveValueComputerPartGUI)this.getGUI()).disableUserInput();
        }
    }

    public int[] getEnabledRange() {
        return new int[]{this.startEnabledRange, this.endEnabledRange};
    }

    public void setEnabledRange(int n, int n2, boolean bl) {
        this.startEnabledRange = n;
        this.endEnabledRange = n2;
        this.grayDisabledRange = bl;
        if (this.displayChanges) {
            ((InteractiveValueComputerPartGUI)this.getGUI()).setEnabledRange(n, n2, bl);
        }
    }

    public void refreshGUI() {
        if (this.displayChanges && this.startEnabledRange != -1 && this.endEnabledRange != -1) {
            ((InteractiveValueComputerPartGUI)this.getGUI()).setEnabledRange(this.startEnabledRange, this.endEnabledRange, this.grayDisabledRange);
        }
    }
}

